/**
 * Projekt Kap10-GPTIM-01
 * ======================
 *
 * Nutzt Kanal 1 des Timers TIM12 zum Ansteuern einer LED. Neben der Nutzung
 * des Compare-Modus ist hier auch die Programmierung der alternativen Funktion
 * von PIN14 von GPIOB interessant.
 */

/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stdint.h>
#include <stdbool.h>

#include <stm32f4xx.h>
#include <mcalGPIO.h>
#include <mcalTimer.h>

/* Prototypen */
bool isGPTimer(TIM_TypeDef *tim);

int main(void)
{
    // MCAL: GPIO-Funktionen
    gpioInitPort(GPIOB);                        // GPIOB: Bustakt aktivieren
    gpioSelectPinMode(GPIOB, PIN14, ALTFUNC);   // PIN14: AF->Modus
    gpioSelectAltFunc(GPIOB, PIN14, AF9);       // AF-Modus = AF9 (TIM12, Channel 1)

    // MCAL: Timer-Funktionen
    timerBusClkOn(TIM12);                       // TIM12: Bustakt aktivieren
    timerSetPrescaler(TIM12, (1600 - 1));       // TIM12: Prescaler = 1600
    timerSetAutoReloadValue(TIM12, (5000 - 1)); // TIM12: 500 ms

    // Timer-Funktionen: Noch nicht in MCAL verfügbar
    // CC1S_Msk konfiguriert Kanal 1 automatisch als Output.
    TIM12->CCMR1 &= ~(TIM_CCMR1_CC1S_Msk  |     // Reset TIM12 CC1S
                      TIM_CCMR1_OC1CE_Msk |     // Reset TIM12 OC1E
                      TIM_CCMR1_OC1M_Msk);      // Reset TIM12 OC1M

    // TIM12_OC1M = 011 (dual) --> Aktiviere Toggle-Mode + Preload
    TIM12->CCMR1 |= TIM_CCMR1_OC1M_0 | TIM_CCMR1_OC1M_1;
    TIM12->CCMR1 |= TIM_CCMR1_OC1PE;

    TIM12->CCR1 = 0;                            // Preload value TIM12/Kanal 1
    TIM12->CCER |= TIM_CCER_CC1E;               // Aktiviere Kanal 1 als Output
    TIM12->CNT  = 0;                            // Reset Counter
    timerStart(TIM12);

//    // MCAL: Timer-Funktionen
//    if (timerSetCapCompMode(TIM12, TIMIO_CH1, TIMIO_OUTPUT, CHN_TOGGLE) == true)
//    {
//        timerSetPreloadValue(TIM12, TIMIO_CH1, 0);
//        timerResetCounter(TIM12);
//        timerStart(TIM12);
//    }

    while(1)
    {

    }
}
