/**
 * Projekt Kap06-EXTI-01
 */

/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>
#include <system_stm32f4xx.h>
#include <mcalGPIO.h>

void EXTIConfigIrq(GPIO_TypeDef *port, PIN_NUM pin);

int main(void)
{
    __disable_irq();

    gpioInitPort(GPIOA);
    RCC->APB2ENR |= RCC_APB2ENR_SYSCFGEN; /* SYSCFG: Clock an */

    /**
     * Konfiguration von GPIOA PA0 und PA1
     */
    gpioSelectPinMode(GPIOA, PIN0, INPUT);
    gpioSelectPinMode(GPIOA, PIN1, OUTPUT);

    // GPIO: Aufnahme in MCAL
    GPIOA->OTYPER &= ~(GPIO_OTYPER_OT0 | GPIO_OTYPER_OT1);
    GPIOA->PUPDR &= ~(GPIO_PUPDR_PUPD0 | GPIO_PUPDR_PUPD1);

    // EXTI: Aufnahme in MCAL
    SYSCFG->EXTICR[0] &= ~0x000F;  /* EXTI0 an */
    EXTI->IMR  |= EXTI_IMR_IM0;    /* EXTI: PA0 Enable IRQ */
    EXTI->FTSR |= EXTI_FTSR_TR0;   /* EXTI: PA0 Fallende Flanke */

    NVIC_EnableIRQ(EXTI0_IRQn);    /* EXTI0: Aktivieren    */

    __enable_irq();

    while (1)
    {
        ;
    }
}

/**
 * EXTI0: Interrupt-Service-Routine
 */
void EXTI0_IRQHandler(void)
{
    gpioTogglePin(GPIOA, PIN1); /* Toggle PA1 */
    EXTI->PR |= EXTI_PR_PR0;    /* Reset IRQ-Pending-Flag */
}
