/**
 * Projekt Kap05-GPIO-02
 */

/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>

#include <mcalGPIO.h>

void delayMillis(uint16_t delay);

int main(void)
{
	// Verwendung von MCAL-Funktionen
	gpioInitPort(GPIOA);
	gpioSelectPinMode(GPIOA, PIN0, OUTPUT);

    while (1)
    {
        delayMillis(500);
        GPIOA->BSRR |= GPIO_BSRR_BS0;     // PA0 = '1'
        delayMillis(500);
        GPIOA->BSRR |= GPIO_BSRR_BR0;     // PA0 = '0'
    }
}

/**
 * !!!Sehr schlechte Version eines Delay!!!
 */
void delayMillis(uint16_t delay)
{
    uint16_t i = 0;

    for (; delay > 0; --delay)
    {
        for (i = 0; i < 1245; ++i)
        {
            ;
        }
    }
}
