/**
 * Projekt Kap11-ACTIM-01
 * ======================
 *
 * Generierung einer Totzeit mit TIM8 zwischen dem Main-Output und seinem
 * komplementären Ausgang.
 */
/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stdint.h>
#include <stdbool.h>

#include <stm32f4xx.h>

#include <mcalGPIO.h>
#include <mcalTimer.h>


int main(void)
{
    gpioInitPort(GPIOA);
    gpioInitPort(GPIOC);

    gpioSelectPinMode(GPIOA, PIN5, ALTFUNC);
    gpioSelectAltFunc(GPIOA, PIN5, AF3);
    gpioSelectPinMode(GPIOC, PIN6, ALTFUNC);
    gpioSelectAltFunc(GPIOC, PIN6, AF3);

    timerBusClkOn(TIM8);
    timerSetPrescaler(TIM8, (16 - 1));
    timerSetAutoReloadValue(TIM8, (1000 - 1));
    timerResetCounter(TIM8);

    timerSetCapCompMode(TIM8, TIMIO_CH1, TIMIO_OUTPUT, CHN_PWM_MODE_1);
    timerSelectCapCompOutType(TIM8, TIMIO_CH1, CHN_ENABLE | CHN_COMPL_ENABLE);
    timerSetPreloadValue(TIM8, TIMIO_CH1, (500 - 1));

    timerBdtrClearRegister(TIM8);
    TIM8->BDTR = 0xFF;            // Maximale Totzeit einstellen
    timerBdtrEnableMainOutput(TIM8, MOE_ON);

    TIM8->CR1 = TIM_CR1_CEN | TIM_CR1_CMS_0 | TIM_CR1_CKD_1;

    while(1)
    {
    }

    return 0;
}

