/**
 * Projekt Kap08-SysTick-04
 */

/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>
#include <system_stm32f4xx.h>
#include <stdint.h>
#include <stdbool.h>

#include <mcalSysTick.h>
#include <mcalGPIO.h>

/* Definitionen */
#define DELAY_PIN0  (200)
#define DELAY_PIN1  (400)

/* Funktionsprototypen */
void updateTimers (uint32_t *list);

/* Globale Variablen */
bool     timerTrigger = FALSE;
uint32_t pin0Timer    = 0UL;
uint32_t pin1Timer    = 0UL;
uint32_t currentTicks = 0UL;

int main (void)
{
    // Liste aller Timer-Variablen, die von SysTick gesteuert werden.
	uint32_t *timerList[] = { &pin0Timer, &pin1Timer };
	uint8_t   arraySize   = sizeof(timerList)/sizeof(uint32_t);

    // SysTick konfigurieren und Delay-Zeiten festlegen
	systickInit (SYSTICK_1MS);
	systickSetMillis(&pin0Timer, DELAY_PIN0);
	systickSetMillis(&pin1Timer, DELAY_PIN1);

    // GPIO-Bustakt aktivieren
	gpioInitPort(GPIOA);

    // Konfiguration: PA0
    gpioSelectPinMode(GPIOA, PIN0, OUTPUT);
    gpioSetOutputType(GPIOA, PIN0, PUSHPULL);
    gpioSelectPushPullType(GPIOA, PIN0, PULLUP);

    // Konfiguration: PA1
    gpioSelectPinMode(GPIOA, PIN1, OUTPUT);
    gpioSetOutputType(GPIOA, PIN1, PUSHPULL);
    gpioSelectPushPullType(GPIOA, PIN1, PULLUP);

    while (1)
    {
        if (timerTrigger == TRUE)             // Hat SysTick getickt?
        {
            systickUpdateTimers ((uint32_t *) timerList, arraySize);
        }

        if (isSystickExpired (pin0Timer))
        {
            gpioTogglePin (GPIOA, PIN0);
            systickSetMillis(&pin0Timer, DELAY_PIN0);
        }

        if (isSystickExpired (pin1Timer))
        {
            gpioTogglePin (GPIOA, PIN1);
            systickSetMillis(&pin1Timer, DELAY_PIN1);
        }
    }
}
