/*
 * clockConfig.c
 *
 *  Created on: 01.11.2021
 *      Author: Ralf
 */
#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>

#include <stm32f4xx.h>
#include <system_stm32f4xx.h>
#include <mcalRCC.h>
#include <mcalFlash.h>

#include <clockConfig.h>

void configClock(uint16_t freq)
{
    uint32_t pllInputFreq = HSE_VALUE / 1000000;    // Auswahl der Eingangsfrequenz für die PLL-Schaltung.

    // Konfiguration der Waitstates
    flashConfigWaitStates(freq);

    // Aktivieren der Taktquelle (HSE oder HSI)
    rccEnableHSE();

    // Wir verwenden PLLP als Ausgang der PLL-Schaltung
    rccSelectSysclkSrc(SYSCLKSRC_PLLP);

#if 0
    // Alternative Funktionen zur Auswahl der SYSCLK-Quelle
    rccSelectSysclkSrc(SYSCLKSRC_HSI);
    rccSelectSysclkSrc(SYSCLKSRC_HSE);
    rccSelectSysclkSrc(SYSCLKSRC_PLLR);
#endif

    // Auswahl der Taktquelle (HSE oder HSI)
    rccSelectPLLClockSource(PLL_SRC_HSE);

    // Berechnung der Werte von PLLN, PLLM and PLLP
    rccSetSysclkFreq(pllInputFreq, freq);

    // Auswahl der Prescaler zum Einstellen der AHB- und APB-Frequenzen
    rccSetAHBPrescaler(SYSCLK_DIV_1);
    rccSetAPB1Prescaler(AHB_DIV_4);
    rccSetAPB2Prescaler(AHB_DIV_2);

    // Nicht vergessen: PLL-Schaltkreis aktivieren
    rccEnableMainPLL();
}
