#ifndef HD44780_TEST_H_INCLUDED
#define HD44780_TEST_H_INCLUDED

// Variablen
unsigned char cmdbuf [2];
unsigned char txtbuf [17];

// Funktionsprototypen fuer Komfortfunktionen.
int hd44780_pre_init (int, uint8_t);        // Erweiterte Initialisierung
int hd44780_clear_display (int);            //
int hd44780_show_cursor (int, uint8_t);     // CURSOR_ON / CURSOR_OFF
int hd44780_cursor_home (int);              //
int hd44780_cursor_blink (int, uint8_t);    // CURS_BLINK_ON / CURSOR_BLINK_OFF
int hd44780_set_line (int, uint8_t);        // Zeilennummer des folgenden Textes
int hd44780_ticker_mode (int, uint8_t);     // TICKER_ON / TICKER_OFF
int hd44780_set_ticker_dir (int, uint8_t);  // TICKER_LEFT / TICKER_RIGHT
int hd44780_text_alignment (int, uint8_t);  // TEXT_LEFT / TEXT_CENTER / TEXT_RIGHT
int hd44780_set_text (int, char *);         // Anzuzeigender Text

void error_message (int, unsigned char *);

// Allgemeine Definitionen
#define DEVICE_NAME             "hd44780"
#define LOW                            0
#define HIGH                           1
#define OFF                            0
#define ON                             1

#define MAX_CHARS_PER_LINE            16
#define MIN_LINES                      1
#define MAX_LINES                      4

// Funktionsnummern fuer die Steuerung des HD44780
#define CLEAR_DISPLAY               0x01
#define CURSOR_HOME                 0x02
#define DISPLAY_ENABLE_DISABLE      0x03
#define CURSOR_MOVE_DIR             0x04
#define CURSOR_BLINK_MODE           0x05
#define CURSOR_ON_OFF               0x06
#define DISPLAY_ON_OFF              0x07
#define DISPLAY_SHIFT_CURSOR_MOVE   0x08
#define CURSOR_MOVE_LEFT_RIGHT      0x09
#define FONT_SELECT                 0x0A
#define NUM_LINES                   0x0B
#define SET_DATA_WIDTH              0x0C
#define SET_LINE_NUM                0x0D
#define SET_TEXT_ALIGN              0x0E
#define SET_TICKER_MODE             0x0F
#define SET_TICKER_DIR              0x10
#define WRITE_TEXT                  0x11

// Fehlercodes
#define HD44780_INVALID_COMMAND     101
#define HD44780_WRITE_TEXT_ERROR    102

// HD44780: Steuerkommandos
#define HD44780_MODE_CTRL           0x00
#define HD44780_MODE_DATA           0x01
#define HD44780_DATA_4_BIT          0x03
#define HD44780_DATA_8_BIT          0x30

// HD44780: Set function (SF)
#define HD44780_SF                  0x20
#define HD44780_SF_FONT_SMALL       0x00    // Font 5x7
#define HD44780_SF_FONT_BIG         0x04    // Font 5x10
#define HD44780_SF_2_LINES          0x08
#define HD44780_SF_1_LINE           0x00
#define HD44780_SF_DATA_4_BIT       0x00

// HD44780: Shift (SH)
#define HD44780_SH                  0x10
#define HD44780_SH_RIGHT            0x04
#define HD44780_SH_LEFT             0x00
#define HD44780_SH_SHIFT            0x08
#define HD44780_SH_CURS_MOVE        0x00

// HD44780 Entry Mode Set (EMS)
#define HD44780_EMS                 0x04
#define HD44780_EMS_DISP_SHIFT_OFF  0x00
#define HD44780_EMS_DISP_SHIFT_ON   0x01
#define HD44780_EMS_CURS_MOVE_INC   0x02
#define HD44780_EMS_CURS_MOVE_DEC   0x00

// HD44780 Display Modes (DM)
#define HD44780_DM                  0x08
#define HD44780_DM_BLINK_OFF        0x00
#define HD44780_DM_BLINK_ON         0x01
#define HD44780_DM_CURS_ON          0x02
#define HD44780_DM_CURS_OFF         0x00
#define HD44780_DM_ON               0x04
#define HD44780_DM_OFF              0x00

// HD44780-Funktionen
#define HD44780_CLEAR_DISPLAY       0x01
#define HD44780_CURSOR_SET_HOME     0x02

// Abhaengig vom gewaehlten LC-Display (1- / 2- / 4-zeilig)
#define HD44780_LCD_LINE_1          0x00
#define HD44780_LCD_LINE_2          0x01
#define HD44780_LCD_LINE_3          0x02
#define HD44780_LCD_LINE_4          0x03

// Offsets zum gezielten Schreiben in eine bestimmte Zeile
#define HD44780_LCD_OFFS_LINE_1     0x80
#define HD44780_LCD_OFFS_LINE_2     0xC0
#define HD44780_LCD_OFFS_LINE_3     0x90
#define HD44780_LCD_OFFS_LINE_4     0xD0


#endif // HD44780_TEST_H_INCLUDED
