#ifndef MAX7219_H_INCLUDED
#define MAX7219_H_INCLUDED


/**
 * Register des MAXIM 7219
 */
#define MAX7219_REG_NOOP        0x00 << 8
#define MAX7219_REG_DIG0        0x01 << 8
#define MAX7219_REG_DIG1        0x02 << 8
#define MAX7219_REG_DIG2        0x03 << 8
#define MAX7219_REG_DIG3        0x04 << 8
#define MAX7219_REG_DIG4        0x05 << 8
#define MAX7219_REG_DIG5        0x06 << 8
#define MAX7219_REG_DIG6        0x07 << 8
#define MAX7219_REG_DIG7        0x08 << 8
#define MAX7219_REG_DECODEMODE  0x09 << 8
#define MAX7219_REG_INTENSITY   0x0A << 8
#define MAX7219_REG_SCANLIMIT   0x0B << 8
#define MAX7219_REG_SHUTDOWN    0x0C << 8
#define MAX7219_REG_DISPTEST    0x0F << 8

/**
 * Betriebsarten
 */
#define OPMODE_SHUTDOWN 0x00
#define OPMODE_NORMAL   0x01;
#define OFF             0x00;
#define ON              0x01;

// Allgemeine Definitionen
#define GPIOS_USED       3
#define GPIO_OFFSET     23
#define GPIO23_DIN      23
#define GPIO24_LOAD     24
#define GPIO25_CLK      25

#define DEVICE_NAME     "max7219imp"
#define LOW             0
#define HIGH            1
#define NUM_MAX7219     1   // Anzahl der MAX7219-Bausteine
#define NUM_COLUMNS     8   // Anzahl der Spalten der Matrix

// Kommandos fuer die Steuerung
#define MAX7219_SET_LOAD_HIGH   (1 << 12)
#define MAX7219_SET_LOAD_LOW    0
#define MAX7219_IS_COMMAND      1
#define MAX7219_IS_DATA         0

// Treiberglobale Variablen
static        dev_t   max7219_numdevs;
static struct cdev   *max7219_object;
static struct class  *max7219_class;
static struct device *max7219_dev;

// Funktionsprototypen f. Standardtreiberfunktionen
static int  __init  max7219_init (void);
static void __exit  max7219_exit (void);
static int          max7219_open (struct inode *device_file, struct file *instance);
static int          max7219_close (struct inode *device_file, struct file *instance);
static ssize_t      max7219_write (struct file *instance, const char __user *user, size_t count, loff_t *offset);
static void         max7219_shutDown (void);

#endif // MAX7219_H_INCLUDED
