#ifndef SN74HC595_H_INCLUDED
#define SN74HC595_H_INCLUDED

// Allgemeine Definitionen
#define GPIOS_USED       4
#define GPIO_OFFSET     23
#define GPIO23_SERDATA  23
#define GPIO24_RCLK     24
#define GPIO25_SRCLK    25
#define GPIO26_SRCLR    26

#define DEVICE_NAME     "sn74hc595"
#define LOW             0
#define HIGH            1
#define NUM_SN74HC595   1           // Anzahl der SN74HC595-Bausteine

// Treiberglobale Variablen
static        dev_t   hc595_dev_num;
static struct cdev   *hc595_object;
static struct class  *hc595_class;
static struct device *hc595_dev;

// Funktionsprototypen
static int __init mod_init (void);
static void __exit mod_exit (void);
static int driver_open (struct inode *device_file, struct file *instance);
static int driver_close (struct inode *device_file, struct file *instance);
static ssize_t driver_write (struct file *instance, const char __user *user, size_t count, loff_t *offset);


#endif // SN74HC595_H_INCLUDED
