#!/bin/bash

#########################################################################
# loopcnt [-u] [-d] endwert                
# 
# Einfaches Shell-Script zum Hochzaehlen bis zu einem vorgegebenen Wert
# bzw. zum Herunterzaehlen von einem vorgegebenen Wert bis auf 0. Das
# Zaehlen wird durch die Funktion count() durchgefuehrt. loopcnt erwartet
# genau zwei Argumente. Weitere Argumente werden ignoriert.
#
# Optionen:
# -u : Hochzaehlen (count up)
# -d : Runterzaehlen (count down)
#
# Version: 0.1
# Autor  : RJ
#########################################################################

# !!! In Shell-Scripts muessen Funktionen VOR ihrer ersten Verwendung definiert werden !!!

# Definition der Funktion countup()
countup ()
{
#    if [ -z "$2" ]
    if [ "$2" = "" ]
    then
        echo Kein Startwert angegeben.
        exit 2
    fi

    echo Maxwert = $2
    echo Countup fertig!
}

# Definition der Funktion countdown()
countdown ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        exit 2
    fi

    echo Startwert = $2
    echo Countdown fertig!
}

# Definition der Funktion usage()
usage ()
{
    echo Die korrekte Syntax lautet: loopcnt [-u, [-d]] endwert
    exit 1
}

#-------------------------------------------------------
# Hier beginnt das >eigentliche< Shell-Script
#-------------------------------------------------------

# Anzahl der Argumente ermitteln
if [ $# -lt 2 ]
then (
    echo Fehler bei der Anzahl der Argumente!
    exit 1
)
fi

# Wert der Argumente testen
if [ "$1" = "-u" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countup expr $2
    exit 0
elif [ "$1" = "-d" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countdown expr $2
    exit 0
else
    usage
fi

