/**
 * main.c
 *
 *  Created on: 25.10.2013
 *      Author: ralf
 *
 * \brief
 */

// Allgemeine Header-Dateien
#include <stdio.h>

// Spezielle Header-Dateien fr das Entwicklungsboard und den Chip
#include "board.h"
#include "chip.h"

/**
 * M A I N - Funktion
 */
int main (void)
{
    // Watchdog-Timer deaktivieren
    WDT_Disable(WDT);

    printf("__TEMPLATE_FLASH_NO_DEBUG__ : Schablone fuer eigene Anwendungen\r\n");
    printf("\r\n");
    printf("\r\n");
    printf("Das Projekt '__TEMPLATE_FLASH_NO_DEBUG__' ist eine Schablone fuer das Anlegen eines\r\n");
    printf("neuen Software-Entwicklungsprojekts fuer den Mikrocontroller Atmel AT91SAM3S4B in\r\n");
    printf("Verbindung mit dem Evaluierungsboard Olimex SAM3-P256. Mit dieser Schablone erzeugte\r\n");
    printf("Projekte sind fuer die Freigabe des Projektes nach Abschluss der Entwicklung ausgelegt\r\n");
    printf("und werden mit Hilfe von SAM-BA in den Flash-Speicher der MCU uebertragen.\r\n");
    printf("\r\n");
    printf("Anforderungen:\r\n");
    printf("   - IDE:        Eclipse IDE 4.3 for C/C++ Developers (Kepler, Service Release 1\r\n");
    printf("   - Toolchain:  Launchpad (GNU ARM Development Tools\r\n");
    printf("   - MinGW32:    Linux 'binutils' fuer Windows\r\n");
    printf("   - ICE:        Segger J-Link oder SAM-ICE Hardware Debugger / In-Circuit-Emulator\r\n");
    printf("   - GDB-Server: Segger J-Link GDB Server (mind. Version 4.62)\r\n");
    printf("   - SAM-BA:     SAM Boot Assistant (mind. Version 2.12)\r\n");
    printf("\r\n");
    printf("   - Erforderliche Eclipse-Plug-ins : \r\n");
    printf("        - C/C++ Development Tools SDK\r\n");
    printf("        - C/C++ Hardware Debugging\r\n");
    printf("        - C99 LR Parser\r\n");
    printf("        - GNU ARM C/C++ Cross Compiler Support\r\n");
    printf("\r\n");
    printf("   - Optionale Eclipse-Plug-ins:\r\n");
    printf("        - Subversive SVN Team Provider (oder anderes Versionierungstool)\r\n");
    printf("        - Subversive SVN Connectors\r\n");
    printf("\r\n");
    printf("Anwendung:\r\n");
    printf("   1. Eclipse Project Explorer --> New C Project\r\n");
    printf("   2. Neues Projekt --> Mausklick rechts --> Import\r\n");
    printf("   3. Muster '__TEMPLATE_FLASH_NO_DEBUG__' auswaehlen --> OK\r\n");
    printf("   4. Alle Dateien ueberschreiben\r\n");
    printf("   5. Eclipse Project Explorer --> Build\r\n");
    printf("\r\n");
    printf("Weitere Infos:\r\n");
    printf("Das neue Projekt 'erbt' saemtliche Einstellungen von '__TEMPLATE_FLASH_NO_DEBUG__, d.h.',\r\n");
    printf("es enthaelt alle Compiler- und Linker-Einstellungen. Als Bibliotheken werden die Release-\r\n");
    printf("Versionen der von Atmel bereitgestellten Peripherie-Treiber verwendet.\r\n");


    while (1)
    {
        ;
    }

    return -1;
}
