
/*************************************************************************
 *
 *    Used with ICCARM and AARM.
 *
 *    (c) Copyright IAR Systems 2008
 *
 *    File name   : sd_ll_spi1.h
 *    Description : SD/MMC low level SPI1 driver
 *
 *    History :
 *    1. Date        : April 10, 2008
 *       Author      : Stanimir Bonev
 *       Description : Create
 *
 *    $Revision: 30123 $
 **************************************************************************/
#include "board.h"
#include "sd_ll_spi1.h"

const Pin pinSD_CD[] = {PIN_SD_CD};
const Pin pinSD_WP[] = {PIN_SD_WP};
const Pin pinSD_CS[] = {PIN_SD_CS};
const Pin pinSD_SCK[] = {PIN_SD_SCK};
const Pin pinSD_MOSI[] = {PIN_SD_MOSI};
const Pin pinSD_MISO[] = {PIN_SD_MISO};

/*************************************************************************
 * Function Name: SdPowerOn
 * Parameters: none
 * Return: none
 *
 * Description: Set power off state
 *
 *************************************************************************/
void SdPowerOn (void)
{

}
/*************************************************************************
 * Function Name: SdPowerOff
 * Parameters: none
 * Return: none
 *
 * Description: Set power off state
 *
 *************************************************************************/
void SdPowerOff (void)
{

}
/*************************************************************************
 * Function Name: SdChipSelect
 * Parameters: Boolean Select
 * Return: none
 *
 * Description: SD/MMC Chip select control
 * Select = true  - Chip is enable
 * Select = false - Chip is disable
 *
 *************************************************************************/
void SdChipSelect (Boolean Select)
{

}
/*************************************************************************
 * Function Name: SdPresent
 * Parameters: none
 * Return: Boolean - true cart present
 *                 - false cart no present
 *
 * Description: SD/MMC precent check
 *
 *************************************************************************/
Boolean SdPresent (void)
{
  return(PIO_Get(pinSD_CD) == 0);
}

/*************************************************************************
 * Function Name: SdWriteProtect
 * Parameters: none
 * Return: Boolean - true cart is protected
 *                 - false cart no protected
 *
 * Description: SD/MMC Write protect check
 *
 *************************************************************************/
Boolean SdWriteProtect (void)
{
  return(PIO_Get(pinSD_WP) != 0);
}

/*************************************************************************
 * Function Name: SdSetClockFreq
 * Parameters: Int32U Frequency
 * Return: Int32U
 *
 * Description: Set SPI ckl frequency
 *
 *************************************************************************/
Int32U SdSetClockFreq (Int32U Frequency)
{
  // Return real frequency
  return(Frequency);
}

/*************************************************************************
 * Function Name: SdInit
 * Parameters: none
 * Return: none
 *
 * Description: Init SPI, Cart Present, Write Protect and Chip select pins
 *
 *************************************************************************/
void SdInit (void)
{
	/* Card present */
	PIO_Configure(pinSD_CD, 1);
	
	/* Write protect */
	PIO_Configure(pinSD_WP, 1);

	/* Chip Select */
	PIO_Configure(pinSD_CS, 1);

	/* SPI lines */
	PIO_Configure(pinSD_SCK, 1);
	PIO_Configure(pinSD_MOSI, 1);
	PIO_Configure(pinSD_MISO, 1);

    /* Enable the SPI clock*/
    PMC_EnablePeripheral(ID_SPI);

    /* SPI and driver initialization. */
    printf("-I- Initializing the SPI for SD card\n\r" ) ;
//    SPI_Configure(SPI, ID_SPI, SPI_MR_MSTR | SPI_MR_MODFDIS | (0xE << SPI_MR_PCS_Pos) ) ; // select CS0
//    SPI_Configure(SPI, ID_SPI, SPI_MR_MSTR | SPI_MR_MODFDIS | (0x0 << SPI_MR_PCS_Pos) ) ; // select CS0
    SPI_Configure(SPI, ID_SPI, SPI_MR_MSTR | SPI_MR_MODFDIS | SPI_MR_PCS(0) ) ; // select CS0
	
	/* Configure CS0 */
    SPI_ConfigureNPCS( SPI, 0, SPI_CSR_CPOL | SPI_CSR_CSNAAT | SPI_CSR_BITS_8_BIT | SPI_CSR_SCBR(160) | SPI_CSR_DLYBS(0xFF) ) ;
	
    /* Enable the SPI */
    SPI_Enable( SPI );
}

/*************************************************************************
 * Function Name: SdTransferByte
 * Parameters: Int8U ch
 * Return: Int8U
 *
 * Description: Read byte from SPI
 *
 *************************************************************************/
Int8U SdTranserByte (Int8U ch)
{
    unsigned int spib;
	
	SPI_Write(SPI, 0, ch);
	while( !SPI_IsFinished(SPI) );

	spib = SPI_Read(SPI);

    return spib;
}

/*************************************************************************
 * Function Name: SdSendBlock
 * Parameters: pInt8U pData, Int32U Size
 *
 * Return: void
 *
 * Description: Read byte from SPI
 *
 *************************************************************************/
void SdSendBlock (pInt8U pData, Int32U Size)
{
  while (Size--)
  {
      SdTranserByte(*pData++);
  }
}

/*************************************************************************
 * Function Name: SdReceiveBlock
 * Parameters: pInt8U pData, Int32U Size
 *
 * Return: void
 *
 * Description: Read byte from SPI
 *
 *************************************************************************/
void SdReceiveBlock (pInt8U pData, Int32U Size)
{
  while (Size--)
  {
      *pData++ = SdTranserByte(0xFF);
  }
}

/*************************************************************************
 * Function Name: SdDly_1ms
 * Parameters: Int32U Delay
 * Return: none
 *
 * Description: Delay [msec]
 *
 *************************************************************************/
void SdDly_1ms (Int32U Delay)
{
volatile Int32U i;
  for(;Delay;--Delay)
  {
    for(i = SD_DLY_1MSEC;i;--i);
  }
}
