/**
 * sdcard.h
 *
 *  Created on: 29.12.2013
 *      Author: ralf
 *
 * \brief
 */

#ifndef SDCARD_H_
#define SDCARD_H_

// Header-Dateien
#include <stdint.h>
#include <stdbool.h>
#include "board.h"


/**
 * Bitfeld fuer die Auswertung der Zustaende von SD-/MMC-Karten
 */
typedef struct
{
    // Informationen waehrend der Initialisierung
    uint16_t sdIdleState                 : 1;
    uint16_t sdVoltRangeAndPattern       : 1;
    uint16_t sdVoltRangeOk               : 1;
    uint16_t sdCardInitDone              : 1;
    uint16_t sdCardReady                 : 1;

    // Informationen ueber den Kartentyp
    uint16_t sdSpecVersion               : 1;
    uint16_t sdCapInfo                   : 1;
    uint16_t sdCardType                  : 1;

    // Informationen waehrend der Nutzung der Karte
    uint16_t sdWriteProtectState         : 1;

    // Derzeit nicht genutzte Bits
    uint16_t sdDummy1                    : 1;
    uint16_t sdDummy2                    : 1;
    uint16_t sdDummy3                    : 1;
    uint16_t sdDummy4                    : 1;
    uint16_t sdDummy5                    : 1;
    uint16_t sdDummy6                    : 1;
} SDINFO_t;

typedef struct
{
    uint8_t  cidManufacturerID;
    uint8_t  cidOemApplicationID[2];
    uint8_t  cidProductName[5];
    uint8_t  cidProductRevision;
    uint8_t  cidProductSerialNumber[4];
    uint16_t cidReserved                 :  4;
    uint16_t cidManufacturingDate        : 12;
    uint8_t  cidCrc7Checksum             :  7;
    uint8_t  cidNotUsed                  :  1;
} CID_t;

typedef struct
{
    uint8_t  csdStructure                :  2;    // Byte 1
    uint8_t  csdReserved1                :  6;

    uint8_t  csdReadDataAccessTime1;              // Byte 2
    uint8_t  csdReadDataAccessTime2;              // Byte 3
    uint8_t  csdMaxDataTransferRate;              // Byte 4

    uint8_t  csdNotUsed1                 :  4;    // Byte 5
    uint8_t  csdCardCommandClassMSB      :  4;

    uint8_t  csdCardCommandClassLSB;              // Byte 6

    uint8_t  csdMaxReadDataBlockLen      :  4;    // Byte 7
    uint8_t  csdPartBlockReadAllowed     :  1;
    uint8_t  csdWriteBlockMisaligned     :  1;
    uint8_t  csdReadBlockMisaligned      :  1;
    uint8_t  csdDsrImplemented           :  1;




} CSD_t;

extern SDINFO_t sdInfo;
extern CID_t    cidInfo;
extern CSD_t    csdInfo;


// Definition der Zustaende von SD-/MMC-Karten
#define SD_CARD_IDLE                         1
#define SD_CARD_VOLTRANGE_AND_PATTERN_OK     1
#define SD_CARD_VOLTRANGE_OK                 1

#define SD_CARD_INIT_FINISHED                1
#define SD_CARD_READY_AND_USABLE             1

#define SD_CARD_WRITE_PROTECT_ON             1
#define SD_CARD_IS_SD_TYPE                   1
#define SD_CARD_VERSION_2_TYPE               1
#define SD_CARD_HIGH_CAP_TYPE                1

#define SD_CARD_MAX_TRY_SEND_CMD41       32000    // Max. 32000 Versuche, CMD41 abzusetzen


// R1-Response
#define SD_CARD_IDLE_STATE                   1
#define SD_CARD_ERASE_RESET              2
#define SD_CARD_ILLEGAL_COMMAND          4
#define SD_CARD_CRC_ERROR                8
#define SD_CARD_ERASE_SEQUENCE_ERROR    16
#define SD_CARD_ADDRESS_ERROR           32

// R3-Response: Die Bits sind in der Antwort um acht Stellen nach rechts verschoben
// Dies wird durch das Links-Schieben korrigiert
#define SD_CARD_VOLTRANGE_VALID          3 << 20    // Betriebsspannung ok? --> Bits 20/21 mssen '1' sein
#define SD_CARD_HIGH_CAP_SUPPORT         1 << 30
#define SDCARD_POWER_UP_FINISHED

// R7-Response: Die Bits sind sind in der Antwort um acht Stellen nach rechts geschoben
// Dies wird durch das Links-Schieben korrigiert
#define SD_VOLTAGE_27_TO_36VOLT          1 << 8     // Betriebsspannung zwischen 2.7 ind 3.6 V

// Fehlermeldungen der SD-/MMC-Karte
#define SD_CARD_OK                       0




// Funktionsprototypen
SDINFO_t      SD_Init(void);
void          SD_SetChipSelect(uint8_t);
uint32_t      SD_SendCommand(unsigned char *);
uint8_t       SD_GetR1Response(void);
uint32_t      SD_GetR3R7Response(void);
bool          SD_CardDetect(void);
bool          SD_WriteProtect(void);
uint32_t      SD_CheckSpecVersion(uint32_t);
void          SD_ClearBitfield(SDINFO_t *);
void          SD_EvalSdInfo(SDINFO_t *);
void          SD_GetCid(CID_t *);
void          SD_GetCsd(CSD_t *);
unsigned char SD_ReadSector(unsigned int, unsigned char *);
unsigned char SD_WriteSector(unsigned int, unsigned char *);


#endif /* SDCARD_H_ */
