/**
 * global.h
 *
 *  Created on: 26.10.2013
 *      Author: ralf
 *
 * \brief
 */

#ifndef GLOBAL_H_
#define GLOBAL_H_

#include <stdint.h>
#include <stdbool.h>

// Globale Funktions-Prototypen
void delayMikros(uint32_t);
void delayMillis(uint32_t);
void delaySeconds(uint32_t);


// Globale Variablen
extern volatile uint32_t dwTimeStamp;
extern volatile bool     systickToggle;
extern volatile bool     voltageDone;
extern volatile bool     temperatureDone;
extern volatile bool     checkAdcRdy;
extern          int16_t  adc_values[];
extern          char     retVal[];


/**
 * Allgemeine Definition
 */
#define BUFFER_SIZE    (2)
#define PDC_BUF_SIZE   (BUFFER_SIZE)
#define VOLT_REF       (3300)
#define MAX_DIGITAL    (4095)


// Port-Definitionen
#define PIN_PA0        { PIO_PA0, PIOA, ID_PIOA, PIO_OUTPUT_0, PIO_DEFAULT }


#endif /* GLOBAL_H_ */
