/**
 * a2d.c : Analog-to-Digital
 *
 *  Created on: 01.12.2013
 *      Author: ralf
 *
 * \brief
 */
#include "board.h"
#include "global.h"
#include "a2d.h"


/**
 * void ADC_Configure (void)
 *
 * \brief
 *
 * @param
 * @return  void
 */
void ADC_Configure(void)
{
    // Initialisierung des ADC
    ADC_Initialize( ADC, ID_ADC );

    /* startup = 15
     * Prescaler = 4
     *     --> ADCClock = MCK / ( (PRESCAL+1) * 2 ) => 64MHz / ((4+1)*2) = 6.4MHz
     */
    ADC_cfgFrequency( ADC, 15, 4 );

    ADC_check( ADC, BOARD_MCK );

    // ADC-Kanal 4 --> Potentiometer
    ADC_EnableChannel(ADC, ADC_CHANNEL_4);

    // ADC-Kanal 5 --> Temperatursensor
    ADC_EnableChannel(ADC, ADC_CHANNEL_5);
    ADC_EnableTS(ADC, ADC_ACR_TSON);


    /* Enable ADC interrupt */
    NVIC_EnableIRQ(ADC_IRQn);

    /* Start conversion */
    ADC_StartConversion(ADC);

    ADC_ReadBuffer(ADC, adc_values, BUFFER_SIZE);

    /* Enable PDC channel interrupt */
    ADC_EnableIt(ADC, ADC_IER_RXBUFF);

}


/**
 * void ADC_IrqHandler (void)
 *
 * \brief
 *
 * @param
 * @return  void
 */
void ADC_IrqHandler(void)
{
    uint32_t status;

    status = ADC_GetStatus(ADC);

    if ( (status & ADC_ISR_RXBUFF) == ADC_ISR_RXBUFF )
    {
        conversionDone = true;

        ADC_ReadBuffer( ADC, adc_values, BUFFER_SIZE ) ;

    }
}


/**
 * void ADC_CheckConversionStatus ()
 *
 * \brief
 *
 * @param
 * @return  void
 */
void ADC_CheckConversionStatus()
{
    uint32_t status;

    status = ADC_GetStatus( ADC ) ;

    // Test: Konvertierung abgeschlossen?
    if ( (status & ADC_ISR_EOC4) == ADC_ISR_EOC4 )
    {
        ADC_StartConversion( ADC ) ;
    }
}


// EOF (a2d.c)
