/**
 * main.c
 *
 *  Created on: 25.10.2013
 *      Author: ralf
 *
 * \brief
 */

// Allgemeine Header-Dateien
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>


// Spezielle Header-Dateien fr das Entwicklungsboard und den Chip
#include "board.h"
#include "board_olimex.h"
#include "chip.h"
#include "global.h"


// Globale Variablen
uint8_t  tableIndex = 0;
uint16_t frequency  = 1000;
uint16_t amplitude  = MAX_DIGITAL / 2;
uint8_t  waveForm   = TRIANGLE;
bool     msgShown   = false;
int8_t   sign       = 1;

const Pin pa0 = PIN_LED_RED;
const Pin pa1 = PIN_LED_GRN;

/**
 * M A I N - Funktion
 */
int main(void)
{
    uint32_t   userInput;


    // Watchdog-Timer deaktivieren
    WDT_Disable(WDT);

    ShowIntro();
    ShowMenu();

    // Konfiguration von PA0 und PA1 als Ausgang zum Ansteuern von LEDs
    PIO_Configure(&pa0, 1);
    PIO_Configure(&pa1, 1);

    // Basiskonfiguration: Dreieck (Triangle), f = 1000Hz, a = 2047
    SysTick_Config( BOARD_MCK / (frequency * SAMPLES) );

    // Konfiguration des Analog Comparator Controllers
    ACC_Configure(ACC,
                  ID_ACC,
                  ACC_SELPLUS_AD12B4,    // Eingang: ueber Poti zugefuehrt
                  ACC_SELMINUS_DAC0,     // Eingang: DAC0 liefert Vergleichsspannung
                  1,                     // Angabe von ACC_MR_ACEN bzw. ACC_MR_ACEN_EN funktioniert nicht!
                  2,                     // Triggerung auf beiden Flanken
                  0);                    // Nicht invertiert

    ACC_SetComparisionPair(ACC, ACC_SELPLUS_AD12B4, ACC_SELMINUS_DAC0);

    NVIC_EnableIRQ(ACC_IRQn);
    ACC_EnableIt(ACC, ACC_IER_CE);

    // Konfiguriert den DACC (prinzipiell entspricht dies nur dem Aufruf von DACC_Initialize()
    // Initialisiere den DACC
    DACC_Initialize( DACC,
                     ID_DACC,
                     0,                  // Hardware-Trigger sind deaktiviert
                     0,                  // Externes Triggersignal aktiviert
                     0,                  // Daten werden als Halbwort uebertragen
                     0,                  // Betriebsart: Normalmodus (nicht Sleep-Modus)
                     BOARD_MCK,          // Hieraus wird der DACC-Takt erzeugt (--> BOARD_MCK / 2)
                     8,                  // Zeit, nach der die Analogzelle aufgefrischt wird
                     DACC_CHANNEL_0,     // Ausgang ist Kanal 0
                     0,                  // Tag-Modus nicht aktiviert
                     16                  // Startzeit
                   );

    // Aktiviere DACC-Kanal #0
    DACC_EnableChannel(DACC, DACC_CHANNEL_0);

    /* Set DAC0 output at ADVREF/2 */
    DACC_SetConversionData(DACC, MAX_DIGITAL/2);


    while (1)
    {
        userInput = UART_GetChar();

        // Zulaessige Eingaben sind '1', '2', '3', 'f'/'F', 'a'/'A', 'm'/'M'
        switch (userInput)
        {
            case '1':
                waveForm = SINUS;
                break;

            case '2':
                waveForm = SAWTOOTH;
                break;

            case '3':
                waveForm = TRIANGLE;
                break;

            case 'f':
            case 'F':
            	printf("\r\n");
            	printf("Frequenz eingeben: \r\n");
                frequency = get4Digits(50, 2500);

                if (frequency == INVALID_VALUE)
                    frequency = 1000;

                printf("\r\nfrequency = %u\r\n", frequency);
                SysTick_Config(BOARD_MCK / (frequency * SAMPLES));
                break;

            case 'a':
            case 'A':
            	printf("\r\n");
            	printf("Amplitude eingeben: \r\n");
            	amplitude = get4Digits(100, 2047);

            	if (amplitude == INVALID_VALUE)
            	    amplitude = MAX_DIGITAL / 2;

            	printf("\r\namplitude = %u\r\n", amplitude);
                break;

            case 'i':
            case 'I':
            	printf("\r\n");

            	if (sign == 1)
            	    printf("Signal: Standard\r\n");
            	else
                    printf("Signal: Invertiert\r\n");

            	sign *= (-1);
                break;

            case 'm':
            case 'M':
                ShowIntro();
                ShowMenu();
                break;
        }

    }

    return -1;
}

void ACC_IrqHandler(void)
{
	uint32_t status;

	status = ACC_GetStatus(ACC);

	// Feststellen, ob ein Interrupt aufgetreten ist
	if ((status & ACC_IMR_CE) == ACC_IMR_CE)
	{
	    // ACC_GetComparisonResult() testet das SCO-Bit des ACC_ISR
		// SCO = Synchronized Compare Output
        if (ACC_GetComparisionResult(ACC, status))
        {
        	PIO_Set(&pa0);
        	PIO_Clear(&pa1);
        } else
        {
        	PIO_Clear(&pa0);
        	PIO_Set(&pa1);
	    }
    }
}
