#include <stdio.h>
#include <stdbool.h>

#include "global.h"

/**
 * void calcTriangleData(void)
 *
 * \brief Berechnung der Daten der Dreiecksignale. Nach der vorgegebenen Anzahl
 *        von Schritten soll das Dreieck vollstaendig sein, d.h. die maximale
 *        Amplitude muss nach der Haelfte der Schritte erreicht werden.
 *
 * param  none
 * return none
 */
void calcTriangleData(void)
{
    float        deltaAmplitude = 2.0 * MAX_DIGITAL / tableSize;
    float        triangle = 0;             // Wert des Ausgangssignals
    unsigned int result;                   // dto., aber als unsigned int

    bool         sign;                     // Immer positiv
    char         triangleAsCharArray[4];   // Fuer Bildschirmanzeige u. Datei
    int          i;                        // Groesse der Tabelle

    // Schleife zur Berechnung des Dreieck-Signals
    for (i = 0; i < tableSize; i++)
    {
        // 'Cast' float --> unsigned int
        result = (unsigned int) triangle;
        if (i < (tableSize / 2))
            triangle += deltaAmplitude;
        else
            triangle -= deltaAmplitude;


        // Umwandlung des float-Wertes in einen String
        sprintf(triangleAsCharArray, "%03X", result);
        triangleAsCharArray[3] = '\0';


        // Ausgabe auf Monitor
        printToScreen(sign, triangleAsCharArray, i, waveForm, tableSize);

        // Ausgabe in Datei
        printToFile(sign, triangleAsCharArray, i, waveForm, tableSize);
    }
}

