#include <stdio.h>
#include <stdbool.h>
#include <math.h>

#include "global.h"


/**
 * void calcSinusData(void)
 *
 * \brief Berechnung der Daten der Sinustabelle
 *
 * param  none
 * return none
 */
void calcSinusData(void)
{
    float        sinus;                 // Wert des Sinus des aktuellen Winkels
    unsigned int result;                // Umwandlung des Sinus --> unsigned int
    bool         sign;                  // Vorzeichen-Flag
    char         sinusAsCharArray[4];   // Wert des Sinus als char*
    float        grad = 0;              // Aktueller Winkel
    float        rad;                   // Winkel im Bogenmaß
    int          i;                     // Anzahl: Sinus-Berechnungen


    // Schleife zur Berechnung der Sinus eines Winkels
    for (i = 0; i < tableSize; i++)
    {
        rad = grad * PI / 180;          // Umrechnung: Grad --> Bogenmaß
        sinus = sin(rad);               // Berechnung des Sinus
        sinus *= MAX_DIGITAL / 2;       // Anpassen an DACC-Amplitude
        grad += 360.0 / tableSize;      // Winkel für nächste Berechnung

        // Vorzeichen des errechneten Sinus ermitteln für die Ausgabe
        if (sinus < 0)
        {
            sinus *= (-1);              // Betrag des errechneten Sinus bilden
            sign = false;               // Vorzeichen --> '-'
        } else
            sign = true;                // Vorzeichen --> '+'

        // 'Cast' float --> unsigned int
        result = (unsigned int) sinus;

        // Umwandlung des float-Wertes in einen String
        sprintf(sinusAsCharArray, "%03X", result);
        sinusAsCharArray[3] = '\0';

        // Ausgabe auf Monitor
        printToScreen(sign, sinusAsCharArray, i, waveForm, tableSize);

        // Ausgabe in Datei
        printToFile(sign, sinusAsCharArray, i, waveForm, tableSize);
    }
}

