/*
 * File:   global.h
 * Author: ralf
 *
 * Created on 26. November 2013, 12:23
 */

#ifndef GLOBAL_H
#define	GLOBAL_H

#ifdef	__cplusplus
extern "C" {
#endif

// Allgemeine Definitionen
#define PI                    3.14159f // Constant value of PI
#define MAX_DIGITAL               4095 // The resolution of the DACC is 12 bit

#define SINUS                        1
#define TRIANGLE                     2
#define SAWTOOTH                     3

#define ERR_NO_OF_ARGS             100
#define ERR_WRONG_WAVEFORM         101
#define ERR_INV_CHARS              102
#define ERR_NOT_MULTIPLE_OF_10     103


// Funktionsprototypen
void usage(int);
void printToFile(bool, char*, int, int, int);
void printToScreen(bool, char*, int, int, int);
char *stringToLowerCase(char*);
int  stringToNumber(char *);
void calcSinusData(void);
void calcTriangleData(void);
void calcSawtoothData(void);


// Globale Variable
extern FILE *fp;
extern bool roundDown;
extern int  tableSize;
extern int  waveForm;
extern bool tableHeaderDone;



#ifdef	__cplusplus
}
#endif

#endif	/* GLOBAL_H */

