/**
 * terminal.c
 *
 *  Created on: 14.11.2013
 *      Author: ralf
 *
 * \brief
 */

#include <stdio.h>

#include "board.h"
#include "global.h"

/**
 * \brief Anzeige der Startinformationen
 */
void ShowIntro(void)
{
    VT100_CLEARSCREEN
    VT100_CURSOR_HOME
    printf("-- Beispiel fuer PWM mit PDC %s --\r\n", SOFTPACK_VERSION);
    printf("-- %s\r\n", BOARD_NAME);
    printf("-- Kompiliert: %s %s --\r\n", __DATE__, __TIME__);
}

/**
 * \brief Anzeige des Hauptmenues
 */
void ShowMenu(void)
{
    printf("\r\n");
    printf("================================================================\r\n");
    printf("Menue: Druecken Sie eine Taste, um die Konfiguration zu aendern.\r\n");
    printf("================================================================\r\n");
    printf("  u : Update der Periodendauer\r\n");
    printf("  d : Einstellen der Dead-time\r\n");
    printf("  o : Output override\r\n");
    printf("\r\n");
    printf("\r\n");
}

/**
 * \brief Eingabe: 2-stelliger numerischer Wert.
 *
 * \return numkey value
 */
uint32_t GetNumkey2Digit(void)
{
    uint32_t numkey;
    uint8_t key1, key2;

    printf("\r\n2 Ziffern eingeben : ");
#if defined (  __GNUC__  )
        fflush(stdout);
#endif
    key1 = UART_GetChar();
    printf("%c", key1);
    key2 = UART_GetChar();
    printf("%c", key2);
    printf("\r\n");

    numkey = (key1 - '0')*10 + (key2 - '0');

    return numkey;
}

// EOF
