/**
 * Datei / File	  : util.c
 * Autor / Author : Ralf Jesse
 * Datum / Date	  : 16.05.2013
 *
 * \brief Hilfsfunktionen zur bitweisen Anzeige von Registerinhalten.
 *        Helper function for the bit-wise display of register contents.
 *
 */


/**
 * Include-Dateien / Header files
 */
#include "board.h"
#include <stdio.h>


/**
 * Konstanten / Constants
 */


/**
 * Externe Referenzen / External references
 */


/**
 * Funktions-Prototypen / Function prototypes
 */
void hex2bin(char*, unsigned int);


/**
 * Name  : hex2bin
 * Input : name <-- Name des Registers
 *         val  <-- Inhalt des Registers
 * Output: --
 *
 * Stellt den Inhalt des angegebenen Registers als Dualzahl dar.
 */
void hex2bin(char *name, unsigned int val)
{
	unsigned int i;                 // Einfacher Zaehler

	// Das MSB ist '1', alle anderen Bits sind '0'
	unsigned int mask = 0x80000000;

	// Ausgabe des Registernamens
	printf("%s = ", name);

	// Jedes Bit wird separat ausgewertet
	for (i = 0; i < 32; i++)
	{
		if ((i % 8 == 0) && (i > 0))
			printf(" ");

		((val & mask) == 0) ? printf("0") : printf("1");

		// Maske auf das nchste Bit setzen
		mask = mask >> 1;
	}

	printf("\r\n");
}

// EOF



