/**
 * Datei / File	  : main.c
 * Autor / Author : Ralf Jesse
 * Datum / Date	  : 08.05.2013
 *
 * \brief Tool zum Auslesen der Chip-ID und weiterer Informationen
 *
 */


/**
 * Include-Dateien / Header files
 */
#include "board.h"
#include <stdio.h>


/**
 * Konstanten / Constants
 */
#define	ATSAM3S4A	0x28800960
#define ATSAM3S2A 	0x288A0760
#define ATSAM3S1A 	0x28890560
#define ATSAM3S4B	0x28900960
#define ATSAM3S2B 	0x289A0760
#define ATSAM3S1B 	0x28990560
#define ATSAM3S4C 	0x28A00960
#define ATSAM3S2C 	0x28AA0760
#define ATSAM3S1C 	0x28A90560
#define ATSAM3S8A 	0x288B0A60
#define ATSAM3S8B 	0x289B0A60
#define ATSAM3S8C 	0x28AB0A60
#define ATSAM3SD8A 	0x298B0A60
#define ATSAM3SD8B 	0x299B0A60
#define ATSAM3SD8C 	0x29AB0A60

/**
 * Externe Referenzen / External references
 */


/**
 * Funktions-Prototypen / Function prototypes
 */


int main(void)
{
	// Lokale Variablen
	int    id;

	printf("\r\n");
	printf("Chip-Informationen\r\n");
	printf("==================\r\n");
	printf("\r\n");

	// Chip-ID
	id = (int) CHIPID->CHIPID_CIDR;		// (1)
	printf("Chip-ID : ");
	printf("0x%X\r\n", id);

	// Chip-Name
	printf("Name    : ");
	switch (id)
	{
		case ATSAM3S1A :
			printf("ATSAM3S1A\r\n");
			break;
		case ATSAM3S1B :
			printf("ATSAM3S1B\r\n");
			break;
		case ATSAM3S1C :
			printf("ATSAM3S1C\r\n");
			break;
		case ATSAM3S2A :
			printf("ATSAM3S2A\r\n");
			break;
		case ATSAM3S2B :
			printf("ATSAM3S2B\r\n");
			break;
		case ATSAM3S2C :
			printf("ATSAM3S2C\r\n");
			break;
		case ATSAM3S4A :
			printf("ATSAM3S4A\r\n");
			break;
		case ATSAM3S4B :
			printf("ATSAM3S4B\r\n");
			break;
		case ATSAM3S4C :
			printf("ATSAM3S4C\r\n");
			break;
		case ATSAM3S8A :
			printf("ATSAM3S8A\r\n");
			break;
		case ATSAM3S8B :
			printf("ATSAM3S8B\r\n");
			break;
		case ATSAM3S8C :
			printf("ATSAM3S8C\r\n");
			break;
		case ATSAM3SD8A :
			printf("ATSAM3SD8A\r\n");
			break;
		case ATSAM3SD8B :
			printf("ATSAM3SD8B\r\n");
			break;
		case ATSAM3SD8C :
			printf("ATSAM3SD8C\r\n");
			break;
	}

	// Chip-Version
	printf("Version : ");
	printf("0x%X\r\n", id & CHIPID_CIDR_VERSION_Msk);

	// EPROC (Embedded Processor)
	printf("EPROC   : ");
	switch (id & CHIPID_CIDR_EPROC_Msk)
	{
		case CHIPID_CIDR_EPROC_ARM946ES :
			printf("ARM946ES\r\n");
			break;
		case CHIPID_CIDR_EPROC_ARM7TDMI :
			printf("ARM7TDMI\r\n");
			break;
		case CHIPID_CIDR_EPROC_CM3 :
			printf("Cortex-M3\r\n");
			break;
		case CHIPID_CIDR_EPROC_ARM920T :
			printf("ARM920T\r\n");
			break;
		case CHIPID_CIDR_EPROC_ARM926EJS :
			printf("ARM926EJS\r\n");
			break;
		case CHIPID_CIDR_EPROC_CA5 :
			printf("Cortex-A5\r\n");
			break;
	}

	// NVPSIZ: Non-volatile Program Memory Size
	printf("NVPSIZ  : ");
	switch (id & CHIPID_CIDR_NVPSIZ_Msk)
	{
		case CHIPID_CIDR_NVPSIZ_NONE :
			printf("0\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_8K :
			printf("8 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_16K :
			printf("16 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_32K :
			printf("32 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_64K :
			printf("64 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_128K :
			printf("128 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_256K :
			printf("256 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_512K :
			printf("512 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_1024K :
			printf("1024 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ_2048K :
			printf("2048 kB\r\n");
			break;
		default :
			printf("Reserviert\r\n");
			break;
	}

	// NVPSIZ2: Second Non-volatile Program Memory Size
	printf("NVPSIZ2 : ");
	switch (id & CHIPID_CIDR_NVPSIZ2_Msk)
	{
		case CHIPID_CIDR_NVPSIZ2_NONE :
			printf("0\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_8K :
			printf("8 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_16K :
			printf("16 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_32K :
			printf("32 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_64K :
			printf("64 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_128K :
			printf("128 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_256K :
			printf("256 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_512K :
			printf("512 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_1024K :
			printf("1024 kB\r\n");
			break;
		case CHIPID_CIDR_NVPSIZ2_2048K :
			printf("2048 kB\r\n");
			break;
		default :
			printf("Reserviert\r\n");
			break;
	}

	// SRAMSIZ: Internal SRAM Size
	printf("SRAMSIZ : ");
	switch (id & CHIPID_CIDR_SRAMSIZ_Msk)
	{
		case CHIPID_CIDR_SRAMSIZ_1K :
			printf("1 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_2K :
			printf("2 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_4K :
			printf("4 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_6K :
			printf("6 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_8K :
			printf("8 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_16K :
			printf("16 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_32K :
			printf("32 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_48K :
			printf("48 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_64K :
			printf("64 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_80K :
			printf("80 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_96K :
			printf("96 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_112K :
			printf("112 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_128K :
			printf("128 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_160K :
			printf("160 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_256K :
			printf("256 kB\r\n");
			break;
		case CHIPID_CIDR_SRAMSIZ_512K :
			printf("512 kB\r\n");
			break;
	}

	// ARCH: Architecture Identifier
	printf("ARCH    : ");
	switch (id & CHIPID_CIDR_ARCH_Msk)
	{
		case CHIPID_CIDR_ARCH_AT91SAM9xx :
			printf("AT91SAM9xx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM9XExx :
			printf("AT91SAM9XExx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91x34 :
			printf("AT91x34\r\n");
			break;
		case CHIPID_CIDR_ARCH_CAP7 :
			printf("CAP7\r\n");
			break;
		case CHIPID_CIDR_ARCH_CAP9 :
			printf("CAP9\r\n");
			break;
		case CHIPID_CIDR_ARCH_CAP11 :
			printf("CAP11\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91x40 :
			printf("AT91x40\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91x42 :
			printf("AT91x42\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91x55 :
			printf("AT91x55\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7Axx :
			printf("AT91SAM7Axx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7AQxx :
			printf("AT91SAM7AQxx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91x63 :
			printf("AT91x63\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7Sxx :
			printf("AT91SAM7Sxx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7XCxx :
			printf("AT91SAM7XCxx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7SExx :
			printf("AT91SAM7SExx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7Lxx :
			printf("AT91SAM7Lxx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7Xxx :
			printf("AT91SAM7Xxx\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91SAM7SLxx :
			printf("AT91SAM7SLxx\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3UxC :
			printf("ATSAM3UxC\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3UxE :
			printf("ATSAM3UxE\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3AxC :
			printf("ATSAM3AxC\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3XxC :
			printf("ATSAM3XxC\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3XxE :
			printf("ATSAM3XxE\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3XxG :
			printf("ATSAM3XxG\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3SxA :
			printf("ATSAM3SxA\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3SxB :
			printf("ATSAM3SxB\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3SxC :
			printf("ATSAM3SxC\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT91x92 :
			printf("AT91x92\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3NxA :
			printf("ATSAM3NxA\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3NxB :
			printf("ATSAM3NxB\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3NxC :
			printf("ATSAM3NxC\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3SDxA :
			printf("ATSAM3SDxA\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3SDxB :
			printf("ATSAM3SDxB\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM3SDxC :
			printf("ATSAM3SDxC\r\n");
			break;
		case CHIPID_CIDR_ARCH_SAM5A :
			printf("ATSAM5A\r\n");
			break;
		case CHIPID_CIDR_ARCH_AT75Cxx :
			printf("AT75Ccc\r\n");
			break;
	}

	// NVPTYP: Non-olatile Program Memory Type
	printf("NVPTYP  : ");
	switch (id & CHIPID_CIDR_NVPTYP_Msk)
	{
		case CHIPID_CIDR_NVPTYP_ROM :
			printf("ROM\r\n");
			break;
		case CHIPID_CIDR_NVPTYP_ROMLESS :
			printf("ROMLESS\r\n");
			break;
		case CHIPID_CIDR_NVPTYP_SRAM :
			printf("SRAM\r\n");
			break;
		case CHIPID_CIDR_NVPTYP_FLASH :
			printf("FLASH\r\n");
			break;
		case CHIPID_CIDR_NVPTYP_ROM_FLASH :
			printf("ROM und FLASH\r\n");
			break;
	}

	// EXT: Extension Flag
	printf("EXT     : ");
	switch (id & CHIPID_CIDR_EXT)
	{
		case 0 :
			printf("Einfache Chip-ID\r\n");
			break;
		case 1 :
			printf("Erweiterte Chip-ID\r\n");
			break;
	}


	while (1)
		;

	// Dieser Punkt sollte nie erreicht werden!
	return 1;
}
// EOF
