/**
 * util.c
 * ======
 *
 * \brief Enthaelt Hilfsfunktionen zur String-Konvertierung und zur Ausgabe
 *        der Ergebnisse auf dem Bildschirm und in eine Datei.
 *
 *        Provides helper functions for the handling of string and to print
 *        the results to the screen, or into a file.
 *
 * Datum/Date  : 26.11.2013
 * Autor/Author: Ralf Jesse
 */
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <math.h>

#include "global.h"
#include "stringutil.h"


/**
 * char * stringToLowerCase(char *string)
 *
 * \brief Umwandlung einer Zeichenkette in Kleinbuchstaben
 *
 * @param  string
 * @return string (umgewandelt)
 */
char *stringToLowerCase(char *string)
{
    int i;
    int len = strlen(string);
    for (i = 0; i < len; i++)
    {
        if (string[i] >= 'A' && string[i] <= 'Z')
        {
            string[i] += 32;
        }
    }
    return string;
}

/**
 * int stringToNumber(char *string)
 *
 * \brief Wandelt einen String in einen Integerwert. Das Ergebnis
 *        wird auf das naechstkleinere Vielfache von 10 abgerundet.
 *
 * @param  string
 * @return wert
 */
int stringToNumber(char *string)
{
    int value = 0;
    int i;
    int len = strlen(string);
    int currentChar;

    for (i = 0; i < len; i++)
    {
        currentChar = string[len - i - 1] - '0';

        if (currentChar >= 0 && currentChar < 10)
            value += (int) currentChar * pow(10, i);
        else
            return -1;
    }

    // Abrunden auf naechstkleineres Vielfaches von 10
    if ((value % 10) != 0)
    {
        value     = (value / 10) * 10;
    }

    return value;
}


/**
 * char* intToString (int16_t number)
 *
 * \brief Wandelt einen vorzeichenbehafteten 16-Bit-Integerwert in einen String um.
 *        Die Funktion ist fuer die Verwendung mit dem ADC/DACC vorgesehen. Da diese
 *        eine maximale Aufloesung von 12 Bit haben, reicht fuer die Umwandlung des
 *        Integerwertes ein 16-Bit-Wert. Die maximale Stellenzahl betraegt vier Stellen
 *        (-4095 --> 0 --> +4095).
 *
 * @param   number
 * @return  char*
 */
char *intToString(int16_t number)
{
    uint16_t divisor = 1000;
    uint16_t tempVal;
    uint8_t  i = 0;
    uint8_t  n;

    // Vorzeichen ermitteln
    if (number < 0)
    {
        retVal[i++] = '-';
        number *= (-1);        // Absolutbetrag bilden
    }
    else
    	retVal[i++] = '+';

    // Das Vorzeichen wurde bereits ermittelt --> daher: Start mit Index = 1
    for (n = 0; n < 4; n++)
    {
        tempVal = number / divisor;
        retVal[i++] = tempVal + '0';
        number -= tempVal * divisor;
        divisor /= 10;
    }
    retVal[i] = '\0';

    return retVal;
}

// EOF (util.c)
