/**
 * buttons.c
 *
 *  Created on: 31.10.2013
 *      Author: ralf
 *
 * \brief
 */

#include "board.h"
#include "chip.h"
#include "global.h"
#include "buttons.h"

const Pin buttons[]           = { BUTTONS };
const Pin pinPB1              = PIN_PUSHBUTTON_1;
const Pin pinPB2              = PIN_PUSHBUTTON_2;

void Configure_Buttons(void)
{
	PIO_Configure(&pinPB1, 1);
	PIO_Configure(&pinPB2, 1);

	PIO_InitializeInterrupts(IRQ_PRIOR_PIO);

	// Besondere Einstellungen fr die Taster
	// Entprellen der Eingaenge
	PIO_SetDebounceFilter(&pinPB1, 10);
	PIO_SetDebounceFilter(&pinPB2, 10);

	// Initialisiert die PIO-Interrupt-Handler (definiert in 'board.h')
    PIO_ConfigureIt(&pinPB1, PB_Handler);
    PIO_ConfigureIt(&pinPB2, PB_Handler);

	// Freigabe der PIO-Controller-Interrupts
	NVIC_EnableIRQ((IRQn_Type) PIOA_IRQn);

	// Aktivieren der PIO-Anschluss-Interrupts
    PIO_EnableIt(&pinPB1);
    PIO_EnableIt(&pinPB2);
}


void PB_Handler(const Pin *pPin)
{
	if (&pinPB1 == pPin)
	{
		pb1Pressed = true;
	}

	if (&pinPB2 == pPin)
	{
		pb2Pressed = true;
	}
}
