/**
 * global.h
 *
 *  Created on: 26.10.2013
 *      Author: ralf
 *
 * \brief
 */

#ifndef GLOBAL_H_
#define GLOBAL_H_

#include <stdint.h>
#include <stdbool.h>

// Globale Funktions-Prototypen
void delayMikros(uint32_t);
void delayMillis(uint32_t);
void delaySeconds(uint32_t);

// Externe Funktionsprototypen
extern void convertTimeToString(uint8_t *, uint8_t *, uint8_t *);
extern void Configure_RTC(void);


// Globale Variablen
extern          char     currentTime[17];
extern volatile uint32_t dwTimeStamp;
extern volatile bool     systickToggle;
volatile        bool     secondEvent;


// Globale Variablen fuer die Uhrenfunktion
uint8_t  hours;
uint8_t  hoursTenner;
uint8_t  hoursOnes;

uint8_t  minutes;
uint8_t  minutesTenner;
uint8_t  minutesOnes;

uint8_t  seconds;
uint8_t  secondsTenner;
uint8_t  secondsOnes;


/**
 * Allgemeine Definition
 */
#define IRQ_PRIOR_PIO    0


/**
 * Fehlercodes
 */
#define SYSTICK_CONFIGURATION_ERROR           -100


/**
 * Definitionen zum Einstellen von Uhrzeit und Datum
 */
#define MODE_AM                               0
#define MODE_PM                               1
#define MODE_24H                              0
#define MODE_12H                              1


// Port-Definitionen
#define PIN_PA0        { PIO_PA0, PIOA, ID_PIOA, PIO_OUTPUT_0, PIO_DEFAULT }


#endif /* GLOBAL_H_ */
