/**
 * main.c
 *
 *  Created on: 25.10.2013
 *      Author: ralf
 *
 * \brief
 */

// Allgemeine Header-Dateien
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>


// Spezielle Header-Dateien fr das Entwicklungsboard und den Chip
#include "board.h"
#include "board_olimex.h"
#include "chip.h"
#include "global.h"


// Globale Variablen
uint8_t  tableIndex = 0;
uint16_t frequency  = 1000;
uint16_t amplitude  = MAX_DIGITAL / 2;
uint8_t  waveForm   = SINUS;
bool     msgShown   = false;
int8_t   sign       = 1;


/**
 * M A I N - Funktion
 */
int main(void)
{
    uint32_t   userInput;


    // Watchdog-Timer deaktivieren
    WDT_Disable(WDT);

    ShowIntro();
    ShowMenu();

    // Basiskonfiguration: Simus, f = 1000Hz, a = 2047
    SysTick_Config( BOARD_MCK / (frequency * SAMPLES) );

    // Konfiguriert den DACC (prinzipiell entspricht dies nur dem Aufruf von DACC_Initialize()
    DACC_Initialize( DACC,
                     ID_DACC,
                     0,              /* Hardware triggers are disabled */
                     0,              /* External trigger */
                     0,              /* Half-Word Transfer */
                     0,              /* Normal Mode (not sleep mode) */
                     BOARD_MCK,
                     8,              /* refresh period */
                     DACC_CHANNEL_0, /* Channel 0 selection */
                     0,              /* Tag Selection Mode disabled */
                     16              /*  value of the start up time */);

    // Aktiviere DACC-Kanal #0
    DACC_EnableChannel(DACC, DACC_CHANNEL_0);

    /* Set DAC0 output at ADVREF/2 */
    DACC_SetConversionData(DACC, MAX_DIGITAL/2);


    while (1)
    {
        userInput = UART_GetChar();

        // Zulaessige Eingaben sind '1', '2', '3', 'f'/'F', 'a'/'A', 'm'/'M'
        switch (userInput)
        {
            case '1':
                waveForm = SINUS;
                break;

            case '2':
                waveForm = SAWTOOTH;
                break;

            case '3':
                waveForm = TRIANGLE;
                break;

            case 'f':
            case 'F':
            	printf("\r\n");
            	printf("Frequenz eingeben: \r\n");
                frequency = get4Digits(50, 2500);

                if (frequency == INVALID_VALUE)
                    frequency = 1000;

                printf("\r\nfrequency = %u\r\n", frequency);
                SysTick_Config(BOARD_MCK / (frequency * SAMPLES));
                break;

            case 'a':
            case 'A':
            	printf("\r\n");
            	printf("Amplitude eingeben: \r\n");
            	amplitude = get4Digits(100, 2047);

            	if (amplitude == INVALID_VALUE)
            	    amplitude = MAX_DIGITAL / 2;

            	printf("\r\namplitude = %u\r\n", amplitude);
                break;

            case 'i':
            case 'I':
            	printf("\r\n");

            	if (sign == 1)
            	    printf("Signal: Standard\r\n");
            	else
                    printf("Signal: Invertiert\r\n");

            	sign *= (-1);
                break;

            case 'm':
            case 'M':
                ShowIntro();
                ShowMenu();
                break;
        }

    }

    return -1;
}
