/**
 * pulsewidthmod.h
 *
 *  Created on: 14.11.2013
 *      Author: ralf
 *
 * \brief
 */

#ifndef PULSEWIDTHMOD_H_
#define PULSEWIDTHMOD_H_

#include "stdint.h"

// PWM-Frequenz in Hz.
#define PWM_FREQUENCY               50

// Duty-Cycle-Werte
#define MAX_DUTY_CYCLE              50
#define MIN_DUTY_CYCLE              0

// Groesse des Duty-Cycle-Buffers
#define DUTY_BUFFER_LENGTH          (MAX_DUTY_CYCLE - MIN_DUTY_CYCLE + 1) * 2

// Einstellung Dead-time
#define DEADTIME_HIGH               0
#define DEADTIME_LOW                0

/**
 * Funktions-Prototypen
 */
void PWM_Initialize(void);

// Puffer fuer den PDC-Transfer des Duty Cycles
uint16_t dutyBuffer[DUTY_BUFFER_LENGTH];


#endif /* PULSEWIDTHMOD_H_ */
