/**
 * Datei: main.c
 * Autor: Ralf Jesse
 * Datum: 02.09.2013
 *
 * \brief
 *
 */


/**
 * Include-Dateien
 */
#include <stdio.h>
#include <stdbool.h>

#include "board.h"
#include "chip.h"
#include "global.h"


// Konstanten
const Pin pa0 = PA0;
const Pin pa1 = PA1;


// Hauptprogramm
int main()
{
	// Watchdog-Timer deaktivieren
	WDT_Disable(WDT);

	// Initialisierung versch. Peripherie
	PIO_Configure(&pa0, 1);
	PIO_Configure(&pa1, 1);

	Configure_Leds();
    Configure_RTT();

    timer_LedGruen = 0;
    timer_LedGelb  = 0;

	// Endlosschleife
	while (1)
	{
		if (alarm == false)
		{
		    // Kernfunktion: Hier beginnt der Teil des Projekts, der
		    // fr das Projekt 10_01_RTT relevant ist!
			if (timer_LedGruen > 5)
			{
				Toggle_PA0();
				LED_Toggle(LED_GRUEN);
				timer_LedGruen = 0;
			}

			if (timer_LedGelb > 10)
			{
				Toggle_PA1();
				LED_Toggle(LED_GELB);
				timer_LedGelb = 0;
			}

			alarm_timer = 0;
			alarm_blink_timer = 0;
		}
		else
		{
            do
            {
                alarm_blink_timer = 0;
                LED_Set(LED_GRUEN);
                LED_Set(LED_GELB);

                // Wartezeit, bis LEDs ausgeschaltet werden
                while (alarm_blink_timer < 5)
                    ;

                alarm_blink_timer = 0;
                LED_Clear(LED_GRUEN);
                LED_Clear(LED_GELB);

                // Wartezeit, bis LEDs wieder eingeschaltet werden
                while (alarm_blink_timer < 5)
                    ;
            }
            while (alarm_timer < 100);

            alarm_timer = 0;
            alarm = false;
        }
	}
}

void Toggle_PA0(void)
{
	if (PIO_GetOutputDataStatus(&pa0) == 0)
		PIO_Set(&pa0);
	else
		PIO_Clear(&pa0);
}

void Toggle_PA1(void)
{
	if (PIO_GetOutputDataStatus(&pa1) == 0)
		PIO_Set(&pa1);
	else
		PIO_Clear(&pa1);
}

// EOF
