/**
 * sdcard.h
 *
 *  Created on: 29.12.2013
 *      Author: ralf
 *
 * \brief
 */

#ifndef SDCARD_H_
#define SDCARD_H_

// Header-Dateien
#include <stdint.h>
#include "board.h"


/**
 * Bitfeld fuer die Auswertung der Zustaende von SD-/MMC-Karten
 */
typedef struct
{
    // Informationen waehrend der Initialisierung
    uint16_t sdIdleState                 : 1;
    uint16_t sdVoltRangeAndPattern       : 1;
    uint16_t sdVoltRangeOk               : 1;
    uint16_t sdCardInitDone              : 1;
    uint16_t sdCardReady                 : 1;

    // Informationen ueber den Kartentyp
    uint16_t sdSpecVersion               : 1;
    uint16_t sdCapInfo                   : 1;
    uint16_t sdCardType                  : 1;

    // Informationen waehrend der Nutzung der Karte
    uint16_t sdWriteProtectState         : 1;

    // Derzeit nicht genutzte Bits
    uint16_t sdDummy1                    : 1;
    uint16_t sdDummy2                    : 1;
    uint16_t sdDummy3                    : 1;
    uint16_t sdDummy4                    : 1;
    uint16_t sdDummy5                    : 1;
    uint16_t sdDummy6                    : 1;
} SDINFO_t;

extern SDINFO_t sdInfo;


// Definition der Zustaende von SD-/MMC-Karten
#define SD_CARD_IDLE                         1
#define SD_CARD_VOLTRANGE_AND_PATTERN_OK     1
#define SD_CARD_VOLTRANGE_OK                 1

#define SD_CARD_INIT_FINISHED                1
#define SD_CARD_READY_AND_USABLE             1

#define SD_CARD_WRITE_PROTECT_ON             1
#define SD_CARD_IS_SD_TYPE                   1
#define SD_CARD_VERSION_2_TYPE               1
#define SD_CARD_HIGH_CAP_TYPE                1

#define SD_CARD_MAX_TRY_SEND_CMD41       32000    // Max. 32000 Versuche, CMD41 abzusetzen


// R1-Response
#define SD_CARD_IDLE_STATE                   1
#define SD_CARD_ERASE_RESET              2
#define SD_CARD_ILLEGAL_COMMAND          4
#define SD_CARD_CRC_ERROR                8
#define SD_CARD_ERASE_SEQUENCE_ERROR    16
#define SD_CARD_ADDRESS_ERROR           32

// R3-Response: Die Bits sind in der Antwort um acht Stellen nach rechts verschoben
// Dies wird durch das Links-Schieben korrigiert
#define SD_CARD_VOLTRANGE_VALID          3 << 20    // Betriebsspannung ok? --> Bits 20/21 mssen '1' sein
#define SD_CARD_HIGH_CAP_SUPPORT         1 << 30
#define SDCARD_POWER_UP_FINISHED

// R7-Response: Die Bits sind sind in der Antwort um acht Stellen nach rechts geschoben
// Dies wird durch das Links-Schieben korrigiert
#define SD_VOLTAGE_27_TO_36VOLT          1 << 8     // Betriebsspannung zwischen 2.7 ind 3.6 V

// Fehlermeldungen der SD-/MMC-Karte
#define SD_CARD_OK                       0




// Funktionsprototypen
SDINFO_t SD_Init(void);
void     SD_SetChipSelect(uint8_t);
uint32_t SD_SendCommand(unsigned char *);
uint8_t  SD_GetR1Response(void);
uint32_t SD_GetR3R7Response(void);
bool     SD_CardDetect(void);
//void     SD_CardDetect(SDINFO_t *);
bool     SD_WriteProtect(void);
uint32_t SD_CheckSpecVersion(uint32_t);
void     SD_ClearBitfield(SDINFO_t *);
void     SD_EvalSdInfo(SDINFO_t *);



#endif /* SDCARD_H_ */
