#include "board.h"
#include "chip.h"
#include "global.h"
#include "a2d.h"
#include "hd44780.h"
#include "stringutil.h"
#include "mathutil.h"
#include "ntc.h"

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

// ADC-Puffer
int16_t adc_values[BUFFER_SIZE] = { 0, 0 };
char text[CHARS_PER_LINE]       = "T=";
char retVal[6]                  = "";
char line2[CHARS_PER_LINE]      = "V=";

// ADC-Kanaele, die ueberwacht werden sollen
uint32_t channels[] = {
                         ADC_CHANNEL_4,
                         ADC_CHANNEL_5
                      };


/**
 * int main (void)
 *
 * \brief   Startpunkt des Programmes zur Ermittlung der Temperatur
 *          und der mit dem Trimmpoti eingestellten Spannung sowie
 *          die Anzeige der gemessenen Werte.
 *
 * @param
 * @return  int  : Wird nicht genutzt
 */
int main(void)
{
	uint32_t i;
	int16_t adcVal;
	uint8_t lenText    = strlen(text);
	uint8_t lenLine2   = strlen(line2);
	char grad          = (char) 0xDFu;
	float temperature;
	float ratio;
	uint8_t offset;

	// Watchdog deaktivieren
	WDT_Disable(WDT);

	// 10 s Timer
	SysTick_Config(BOARD_MCK / (100000));
	ADC_Configure(
                   ADC,
                   channels,                          // Liste der AD-Eingaenge
                   sizeof(channels)/sizeof(uint32_t), // Anzahl der AD-Eingaenge, die erfasst werden sollen
                   15,                                // Startup-Zeit
                   4                                  // Prescaler
                 );

	HD44780_Configure();

	lenText = strlen(text);

	while (1)
	{
		// Nach jeweils einer Sekunde wird getestet, ob die Konvertierung
		// abgeschlossen ist.
		if (checkAdcRdy == true)
		{
			checkAdcRdy = false;
			ADC_CheckConversionStatus();
		}

		// Anzeige der gemessenen Temperatur
		if (temperatureDone)
		{
			for (i = 0; i < BUFFER_SIZE; i++)
			{
                adcVal = ADC_GetConvertedData(ADC, ADC_CHANNEL_5) * VOLT_REF / MAX_DIGITAL;
                ratio  = (float) adcVal / (float) MAX_DIGITAL;
				temperature = NtcRatioToTemperature(ratio) - 273.15;

				offset = floatToCharArray(temperature, retVal);
				strcat(text, retVal);
				offset = strlen(text);
				text[offset++] = grad;
				text[offset++] = 'C';

				HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_1, text);
				text[lenText] = '\0';
			}
			temperatureDone = false;
		}

		// Anzeige der mit dem Poti eingestellten Spannung
		if (voltageDone)
		{
            for ( i = 0 ; i < BUFFER_SIZE ; i++ )
            {
                adcVal = ADC_GetConvertedData(ADC, ADC_CHANNEL_4) * VOLT_REF / MAX_DIGITAL;

                offset = intToCharArray(adcVal, retVal);
                strcat(line2, retVal);
                offset = strlen(line2);
                line2[offset++] = 'm';
                line2[offset++] = 'V';

                HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_2, line2);
                line2[lenLine2] = '\0';
            }
		    voltageDone = false;
		}
	}
}

