/*************************************************************************
 *
 *    Used with ICCARM and AARM.
 *
 *    (c) Copyright IAR Systems 2005
 *
 *    File name   : ntc.c
 *    Description : NTC termistor module
 *
 *    History :
 *    1. Date        : July 28, 2005
 *       Author      : Stanimir Bonev
 *       Description : Create
 *
 *    $Revision: 33388 $
**************************************************************************/
#include <stdio.h>
#include <stdint.h>
#include <math.h>
#include "ntc.h"

// NTC device depends parameters
#define A   (double)-14.6337
#define B   (double) 4791.842
#define C   (double)-115334
#define D   (double)-3730535

#define A1  (double)3.354016E-3
#define B1  (double)2.565890E-4
#define C1  (double)2.622013E-6
#define D1  (double)6.38309E-7

/*************************************************************************
 * Function Name: NtcRatioToTemperature
 * Parameters: Flo32 Ratio
 *
 * Return: Flo32
 *
 * Description: Calculate temperature by Rt to Rref ratio
 *
 *************************************************************************/
float NtcRatioToTemperature (float ratio)
{
	double Temp,TempLn;
	float  r = (1 - ratio) / ratio;

	if(ratio==0)
    {
        return(0);
    }

    TempLn = logl(((double) 1 - ratio) / ratio);
    Temp = A1 + TempLn*B1 + TempLn*TempLn*C1+TempLn*TempLn*TempLn*D1;

    return((float)((double)1/Temp));
}

/*************************************************************************
 * Function Name: NtcTemperatureToRatio
 * Parameters: Flo32 Ratio
 *
 * Return: Flo32
 *
 * Description: Calculate the ratio from temperature
 *
 *************************************************************************/
float NtcTemperatureToRatio (float T)
{
    double Temp;

    Temp = exp(A + B/T + C/(T*T) + D/(T*T*T));

    return((float)((double)1/(Temp+1)));
}

