
#include "board.h"
#include "chip.h"
#include "global.h"
#include "a2d.h"
#include "hd44780.h"
#include "stringutil.h"

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>


// ADC-Puffer
int16_t adc_values[BUFFER_SIZE] = { 0 } ;
char    retVal[6];


int main( void )
{
    uint32_t i ;
    int16_t  adcVal;
    char     text[17] = "";

    // Watchdog deaktivieren
    WDT_Disable( WDT ) ;

    // 10 s Timer
    SysTick_Config(BOARD_MCK / (100000));
    ADC_Configure();
    HD44780_Configure();

    while (1)
    {
        // Nach jeweils einer Sekunde wird getestet, ob die Konvertierung
    	// abgeschlossen ist.
        if (checkAdcRdy == true)
        {
            checkAdcRdy = false;
            ADC_CheckConversionStatus();
        }

        // Anzeige des gemessenen Wertes
        if (conversionDone)
        {
            *text = '\0';
            for ( i = 0 ; i < BUFFER_SIZE ; i++ )
            {
                HD44780_ClearDisplay();

                adcVal = adc_values[i] * VOLT_REF / MAX_DIGITAL;
                strcat(text, "U=");
                strcat(text, intToString(adcVal));
                strcat(text, "mV");

                HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_1, text);
                printf( "Volt:%d mV\r\n", adcVal) ;
            }
            conversionDone = false ;
        }
    }

}

