/*
 * hd44780.h
 *
 *  Created on: 29.10.2013
 *      Author: ralf
 */

#ifndef HD44780_H_
#define HD44780_H_

#include "board.h"

/**
 * Prototypen
 */
void HD44780_Configure(void);
void HD44780_PrintText(uint8_t, uint8_t, char *);
void HD44780_BlinkText(uint8_t, uint8_t, char *);
void HD44780_TextTicker(uint8_t, uint8_t, char *);
void HD44780_ClearDisplay(void);
void HD44780_ClearLine(uint8_t);


// Allgemeine Definitionen fuer ein 16x4 Display. Passen Sie die Werte
// an, wenn Sie ein anderes Display verwenden. Der Wert von LCD_MAX_LINES
// muss um 1 kleiner sein, als die tatsaechlich vorhandenen Zeilen.
#define CHARS_PER_LINE  16
#define LCD_MAXLINES    2

// Auswahl der Datenbusbreite
#define LCD_MODE_4_BIT
//#define LCD_MODE_8_BIT

// Textausrichtung
#define LCD_TEXT_LEFT             0
#define LCD_TEXT_CENTER           1
#define LCD_TEXT_RIGHT            2

// Blinken fuer eine Zeile ein- oder ausschalten
#define LCD_SINGLE_LINE_BLINK_OFF 0
#define LCD_SINGLE_LINE_BLINK_ON  1

// Text-Ticker-Funktion, Einstellung der Laufrichtung
#define LCD_TICKER_LEFT           0
#define LCD_TICKER_RIGHT          1


// Datenleitungen
// Im 8-Bit-Mode werden vier weitere Ports benoetigt
#ifdef LCD_MODE_8_BIT
#define PIN_DB0         {PIO_PA0, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_DB1         {PIO_PA1, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_DB2         {PIO_PA2, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_DB3         {PIO_PA3, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#endif // LCD_MODE_8_BIT

#define PIN_DB4         {PIO_PA4, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_DB5         {PIO_PA5, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_DB6         {PIO_PA6, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_DB7         {PIO_PA7, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}

// Steuerleitungen
#define OUT_PIN_RS      {PIO_PA8, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define OUT_PIN_ENABLE  {PIO_PA9, PIOA, ID_PIOA, PIO_OUTPUT_1, PIO_DEFAULT}
#define PIN_RS          0
#define PIN_ENABLE      1

#ifdef LCD_MODE_8_BIT
#define LCD_DATA        PIN_DB0, PIN_DB1, PIN_DB2, PIN_DB3, PIN_DB4, PIN_DB5, PIN_DB6, PIN_DB7
#else
#define LCD_DATA        PIN_DB4, PIN_DB5, PIN_DB6, PIN_DB7
#endif // LCD_MODE_8BIT

#define LCD_CONTROL     OUT_PIN_RS, OUT_PIN_ENABLE

// Steuerkommandos
#define INSTR_WR                0
#define DATA_WR                 1
#define LCD_PRE_INIT_4_BIT      0x03
#define LCD_PRE_INIT_8_BIT      0x30

#define LCD_DISP_CLEAR          0x01
#define LCD_RETURN_HOME         0x02

#define LCD_EMS                 0x04    // EMS = Entry Mode Set
#define LCD_EMS_DISP_SHIFT_ON   0x01
#define LCD_EMS_DISP_SHIFT_OFF  0x00
#define LCD_EMS_CURS_MOVE_INC   0x02
#define LCD_EMS_CURS_MOVE_DEC   0x00

#define LCD_DM                  0x08    // DM = Display Mode
#define LCD_DM_BLINK_ON         0x01
#define LCD_DM_BLINK_OFF        0x00
#define LCD_DM_CURSOR_ON        0x02
#define LCD_DM_CURSOR_OFF       0x00
#define LCD_DM_ON               0x04
#define LCD_DM_OFF              0x00

#define LCD_SH                  0x10    // SH = Shift
#define LCD_SH_SHIFT_RIGHT      0x04
#define LCD_SH_SHIFT_LEFT       0x00
#define LCD_SH_DISP_SHIFT       0x08
#define LCD_SH_CURS_MOVE        0x00

#define LCD_SF                  0x20    // SF = Set Function
#define LCD_SF_FONT_BIG         0x04    // Font = 5 x 10
#define LCD_SF_FONT_SMALL       0x00    // Font = 5 x 7
#define LCD_SF_2_LINES          0x08
#define LCD_SF_1_LINE           0x00
#define LCD_SF_DATA_8_BIT       0x10
#define LCD_SF_DATA_4_BIT       0x00

#define LCD_LINE_1              1
#define LCD_LINE_2              2
#define LCD_LINE_3              3
#define LCD_LINE_4              4
#define LCD_OFFSET_LINE_1       0x80;
#define LCD_OFFSET_LINE_2       0xC0;
#define LCD_OFFSET_LINE_3       0x90;
#define LCD_OFFSET_LINE_4       0xD0;


#endif /* HD44780_H_ */
