/**
 * terminal.c
 *
 *  Created on: 07.11.2013
 *      Author: ralf
 *
 * \brief
 */

#include <stdint.h>
#include <stdio.h>
#include "global.h"
#include "tcWave.h"


void DisplayMenu(void)
{
    uint8_t i;

    VT100_CLEARSCREEN
    VT100_CURSOR_HOME

    printf("Projekt: 11_01_TIMER_COUNTER\r\n");
    printf("============================\r\n\r\n");

    printf("Hauptmenue\r\n");
    printf("----------\r\n");
    printf("Einstellung: Waveform\r\n");
    for (i = 0; i < numConfigurations; i++)
    {
        printf("  %d: Frequenz = %4u Hz, Tastverhaeltnis = %2u%%\r\n", i,
               (unsigned int) waveformConfigurations[i].frequency,
               (unsigned int) waveformConfigurations[i].dutyCycle);
    }

    printf("  ---------------------------------------------  \r\n");
    printf("  c: Impulse zaehlen\r\n");
    printf("  s: Stoppt das Zaehlen von Impulsen / Anzeige des Ergebnisses\r\n");
    printf("  h: Anzeige dieses Menues\r\n");
    printf("\r\n\r\n");
}

// EOF
