/**
 * Datei: wdt_10_03.c
 * Autor: Ralf Jesse
 * Datum: 08.10.2013
 *
 * \brief
 *
 */

/**
 * Include-Dateien
 */
#include <stdio.h>
#include <stdbool.h>

#include "board.h"
#include "chip.h"
#include "global.h"

/**
 * Configure_WDT
 *
 * \brief Konfiguration des Watchdog-Timers.
 *        In Abhaengigkeit vom Parameter wdtConfig erzeugt der WDT wahlweise
 *        einen Interrupt oder einen System-Reset.
 *
 * @param  uint8_t wdtConfig
 * @return none
 */
void Configure_WDT(uint8_t wdtConfig)
{
    // WDT soll Interrupt ausloesen, der separat behandelt wird
    if (wdtConfig == WDT_TRIGGER_IRQ)
    {
        WDT_Enable(WDT, WDT_MR_WDFIEN | WDT_MR_WDDBGHLT | WDT_MR_WDIDLEHLT | (wdtPeriod << 16) | wdtPeriod);
        NVIC_DisableIRQ(WDT_IRQn);
        NVIC_ClearPendingIRQ(WDT_IRQn);
        NVIC_SetPriority(WDT_IRQn, IRQ_PRIOR_WDT);
        NVIC_EnableIRQ(WDT_IRQn);
    }

    // WDT soll Reset ausloesen
    if (wdtConfig == WDT_TRIGGER_RESET)
    {
    	printf("WDT-Reset --> Reset des Systems, Programm startet neu\r\n");
        WDT_Enable(WDT, WDT_MR_WDRSTEN | WDT_MR_WDDBGHLT | WDT_MR_WDIDLEHLT | (wdtPeriod << 16) | wdtPeriod);
    }
}


/**
 * WDT_IrqHandler
 *
 * \brief Interrupt-Service-Routine fuer den Watchdog-Timer
 *
 * @param  none
 * @return none
 */
void WDT_IrqHandler(void)
{
    volatile uint32_t wdtState ;

    /* Statusregister durch Auslesen loeschen */
    wdtState = WDT_GetStatus(WDT);

    printf( "WDT-Interrupt --> Neustart des WDT\r\n");
    LED_Toggle(LED_GREEN);
    WDT_Restart( WDT ) ;
}

// EOF
