/**
 * Datei: main.c
 * Autor: Ralf Jesse
 * Datum: 08.10.2013
 *
 * \brief Beispielprogramm zur Nutzung des Watchdog-Timers.
 *
 *        Anmerkung:
 *        ----------
 *        Das Programm funktioniert nur im Flash-Speicher. Der Grund hierfuer:
 *        Das WDT_MR (WDT Mode Register) kann nach einem Reset nur einmal neu
 *        beschrieben werden. Dies wird unter Verwendgung des SAM-BA Bootloaders
 *        aber bereits einmalig getan: Ein erneuter Schreibversuch ist daher nicht
 *        moeglich.
 */

/**
 * Include-Dateien
 */
#include <stdio.h>
#include <stdbool.h>

#include "board.h"
#include "chip.h"
#include "global.h"


int main(void)
{
    sysTickEvent = false;

    // Erzeugung eines 1-Millisekunden-Taktes aus dem Systemtakt
    // Dieser ist Voraussetzung dafuer, dass das Beispiel funktioniert.
    if ( SysTick_Config(BOARD_MCK / (1000)) )
    {
        printf( "-F- Systick Konfigurationsfehler\n\r" ) ;
    }


    Configure_Ports();
    Configure_Leds();
    wdtPeriod = WDT_GetPeriod(WDT_PERIOD);

    VT100_CURSOR_HOME
    VT100_CLEARSCREEN
    LED_Clear(LED_GREEN);
    LED_Clear(LED_YELLOW);
    printf("Demo-Programm fuer Watchdog-Timer\r\n");
    printf("PB1 --> WDT erzeugt Interrupt\r\n");
    printf("PB2 --> WDT erzeugt Reset/Restart\r\n");



    while(1)
    {
        if (sysTickEvent == true)
        {
            sysTickEvent = false;

            if (gSystick % WDT_RESET_PERIOD == 0)
            {
                WDT_Restart(WDT);
            }
        }

        if (pb1Pressed == true)
        {
            pb1Pressed = false;

            VT100_CURSOR_HOME
            VT100_CLEARSCREEN
            printf("WDT erzeugt Interrupt\r\n");
            Configure_WDT(WDT_TRIGGER_IRQ);

            // Simulation einer durch einen Programmfehler erzeugten Endlosschleife
            printf("Eintritt in Endlosschleife...\r\n");
            while (1);
        }

        if (pb2Pressed == true)
        {
            pb2Pressed = false;

            VT100_CURSOR_HOME
            VT100_CLEARSCREEN
            printf("WDT erzeugt Reset\r\n");
            Configure_WDT(WDT_TRIGGER_RESET);

            // Simulation einer durch einen Programmfehler erzeugten Endlosschleife
            printf("Eintritt in Endlosschleife...\r\n");
            LED_Set(LED_YELLOW);
            while (1);
        }
    }
}


/**
 * Systick_Handler()
 *
 * \brief Interrupt-Service-Routine fuer den Systemtakt
 */
void SysTick_Handler( void )
{
    sysTickEvent = true ;
    gSystick++ ;
}


// EOF
