/**
 * Projekt: 07_01_LCD
 *
 * File	  : main.c
 * Author : Ralf Jesse
 * Date	  : 29.10.2013
 *
 * \brief
 *
 */


/**
 * Header files
 */
#include <stdio.h>
#include <stdint.h>

#include "board.h"
#include "global.h"
#include "hd44780.h"
#include "buttons.h"


// Globale Variablen
char currentTime[17]    = "00:00:00        ";
char alarmClockTime[17] = "00:00:00        ";
char currentDate[17]    = "Sa., 01.01.2000 ";
char dateYearLCD[17]    = "Jahr : 2000     ";
char dateMonthLCD[17]   = "Monat: Jan.     ";
char dateDayLCD[17]     = "Tag  : Sa., 01  ";

char months[12][5] = {
                          "Jan.",
                          "Feb.",
                          "Mar.",
                          "Apr.",
                          "Mai ",
                          "Jun.",
                          "Jul.",
                          "Aug.",
                          "Sep.",
                          "Okt.",
                          "Nov.",
                          "Dez."
                      };

char days[7][3]    = {
                          "Mo",
		                  "Di",
		                  "Mi",
		                  "Do",
		                  "Fr",
		                  "Sa",
		                  "So"
                      };


bool stateModeChanged;


int main ()
{
	// Watchdog deaktivieren
	WDT_Disable(WDT);

    // Initialisierung verwendeter Variablen
    rtcSetupStarted  = false;           // Wird 'true', wenn der RTC konfiguriert wird. Jeder
                                        // Setupmodus (Uhrzeit/Weckzeit/Datum/Alarmdatum) wird
                                        // getrennt behandelt. Daher ist es erforderlich, bei
                                        // JEDER RTC-Einstellung den RTC-Setupmodus zu aktivieren.

    stateModeChanged = false;           // Wird 'true', wenn bei einem Wechsel von einem Status
                                        // in den Folgestatus eine neue Anzeige auf dem LCD
                                        // erscheinen soll.
    secondEvent      = false;           // Wird im Sekundenrhythmus zu 'true' und in der while(1)-
                                        // Schleife zu 'false'.
    alarmCanceled    = false;

    rtcMode          = MODE_RTC_SET_CLOCK;
    clockType        = NORMAL_CLOCK;
    clockMode        = MODE_24H;

    // ACHTUNG:
    // Bei unserem Board wurde beim Auslesen des Datums IMMER das Jahr 20xx ausgegeben.
    // Ein Datum im Jahr 19xx wurde demnach immer auf 20xx 'korrigiert'. Ob dies ein
    // Fehler in der RTC ist, ist unbekannt! Aus diesem Grund wurde der entsprechende
    // Programmcode auskommentiert und durch Setzen des Jahres auf 20xx festgelegt. 19xx
    // kann also nicht ausgewhlt werden!

    // Setzt das Default-Datum auf den 01.01.2000
    // dateDayOfWeek = 6 --> Der 1.1.2000 war ein Samstag
    dateCentury      = CENTURY_21;
    dateYear         = 0;
    dateMonth        = JANUARY;
    dateDayOfWeek    = 6;
    dateDay          = 1;

    // Konfiguration der RTC
    Configure_RTC();

    // Erzeugung eines 10s-Taktes aus dem Systemtakt
    if (SysTick_Config(BOARD_MCK / 100000))
    {
        return SYSTICK_CONFIGURATION_ERROR;
    }

    // Konfiguration von Pushbutton PB1 und PB2
    Configure_Buttons();

    // LCD: Initialisierung des LCD-Controllers
    HD44780_Configure();

    // Vor dem Eintritt in die Endlosschleife die letzte Uhrzeit und das letzte Datum auslesen
    RTC_GetTime(RTC, &hours, &minutes, &seconds);
    convertTimeToString(&hours, &minutes, &seconds);
    RTC_GetDate(RTC, &dateYear, &dateMonth, &dateDay, &dateDayOfWeek);
    convertDateToString(&dateYear, &dateMonth, &dateDay, &dateDayOfWeek);

    while(1)
    {
        // Bei jedem Durchlauf testen, ob der RTC neu eingestellt werden soll
        setNewState();

        // Anzeige der aktuellen Uhrzeit
        if (secondEvent == true && rtcSetupStarted == false)
        {
            secondEvent = false;
            HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_1, "Normalbetrieb   ");
            HD44780_ClearLine(LCD_LINE_2);

            RTC_GetTime(RTC, &hours, &minutes, &seconds);
            convertTimeToString(&hours, &minutes, &seconds);
            HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_3, currentTime);

            RTC_GetDate(RTC, &dateYear, &dateMonth, &dateDay, &dateDayOfWeek);
            convertDateToString(&dateYear, &dateMonth, &dateDay, &dateDayOfWeek);
            HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_4, currentDate);
        }

        // Anzeigen, dass ein Alarm eingetreten ist
        if (alarmEvent == true && alarmCanceled == false)
        {
            HD44780_ClearDisplay();
            HD44780_PrintText(LCD_TEXT_CENTER, LCD_LINE_2, "!!! WECKER !!!");
            HD44780_PrintText(LCD_TEXT_CENTER, LCD_LINE_3, "!!! KLINGELT !!!");

            if (pb1Pressed == true || pb2Pressed == true)
            {
                pb1Pressed = false;
                pb2Pressed = false;

                alarmEvent    = false;
                alarmCanceled = true;
            }
        }
    }
    return -1;
}

// EOF


