/**
 * File	  : main.c
 * Author : Ralf Jesse
 * Date	  : 06.05.2013
 *
 * \brief
 *
 */


/**
 * Header files
 */
#include "board.h"
#include <stdio.h>
#include <stdint.h>

#include "segments.h"

/**
 * Externe Referenzen
 */
extern uint8_t dig_1;
extern uint8_t dig_2;
extern uint8_t dig_3;
extern uint8_t dig_4;

extern void init_Display(void);
extern void send_Data(uint8_t, uint8_t);
extern void delayMillis(uint32_t);


/**
 * main
 *
 * @param  none
 * @return int
 *
 * \brief  Ansteuerung von vier 7-Segment-Anzeigen in Form eines
 *         einfachen Zaehlers. Sobald der maximale Zaehlerstand von
 *         9999 erreicht ist, werden die vier Anzeigen mitsamt der
 *         Ports neu initialisiert.
 */
int main()
{
	WDT_Disable(WDT);

    // Der System-Timer erzeugt einen Takt von 10s.
    if (SysTick_Config(BOARD_MCK / 100000))
    {
        printf("Fehler bei SysTick-Konfiguration");
        return -1;
    }

    init_Display();

    while (1)
	{
        send_Data(dig_1, LATCH_1);
        dig_1++;
        delayMillis(100);

        if (dig_1 > 9)
        {
        	dig_1 = 0;
            send_Data(dig_1, LATCH_1);
        	dig_2++;
            send_Data(dig_2, LATCH_2);
        }

        if (dig_2 > 9)
        {
        	dig_2 = 0;
        	send_Data(dig_2, LATCH_2);
        	dig_3++;
        	send_Data(dig_3, LATCH_3);
        }

        if (dig_3 > 9)
        {
        	dig_3 = 0;
        	send_Data(dig_3, LATCH_3);
        	dig_4++;
        	send_Data(dig_4, LATCH_4);
        }

        if (dig_4 > 9)
        {
        	dig_4 = 0;
            init_Display();
        }
	}

	return 0;
}

// EOF


