/**
 * Projekt: 07_01_LCD
 *
 * File	  : main.c
 * Author : Ralf Jesse
 * Date	  : 29.10.2013
 *
 * \brief
 *
 */


/**
 * Header files
 */
#include <stdio.h>
#include <stdint.h>

#include "board.h"
#include "hd44780.h"
#include "global.h"


/**
 * Konstanten
 */

int main ()
{
	// Watchdog deaktivieren
	WDT_Disable(WDT);

	// Erzeugung eines 10s-Taktes aus dem Systemtakt
    if (SysTick_Config(BOARD_MCK / 100000))
    {
        printf( "-F- Systick Konfigurationsfehler\n\r" );
    }

    // LCD: Initialisierung des LCD-Controllers
    HD44780_Configure();

    while (1)
	{
        HD44780_TextTicker(LCD_TICKER_LEFT, LCD_LINE_1, "ATMEL");
        HD44780_BlinkText(LCD_TEXT_CENTER, LCD_LINE_2, "CORTEX-M3");
        HD44780_TextTicker(LCD_TICKER_RIGHT, LCD_LINE_3, "SAM3S4B");
        HD44780_BlinkText(LCD_TEXT_CENTER, LCD_LINE_4, "Proj. 07_01_LCD");

        delayMillis(250);
	}
}

// EOF


